/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.IterationTestPlanItemDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestSuiteDto;
import org.squashtest.tm.plugin.rest.repository.RestIterationTestPlanItemRepository;
import org.squashtest.tm.plugin.rest.repository.RestTestSuiteRepository;
import org.squashtest.tm.plugin.rest.service.RestTestSuiteService;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.campaign.CustomIterationModificationService;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.campaign.TestSuiteModificationService;
import org.squashtest.tm.service.campaign.TestSuiteTestPlanManagerService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;

@Service
@Transactional
public class RestTestSuiteServiceImpl
implements RestTestSuiteService {
    @Inject
    private RestTestSuiteRepository testSuiteRepository;
    @Inject
    private RestIterationTestPlanItemRepository itpiRepository;
    @Inject
    private CustomIterationModificationService customIterationModificationService;
    @Inject
    private TestSuiteTestPlanManagerService testSuiteTestPlanManagerService;
    @Inject
    private TestSuiteModificationService testSuiteModificationService;
    @Inject
    private PrivateCustomFieldValueService customValueService;
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private CustomFieldValueHelper customFieldValueHelper;
    @Inject
    private TestSuiteDao testSuiteDao;
    @Inject
    private RestTestSuiteRepository restTestSuiteRepository;
    @Inject
    private IterationTestPlanDao itemTestPlanDao;
    @Inject
    private CustomTestSuiteModificationService customTestSuiteModificationService;
    @Inject
    private CampaignNodeDeletionHandler campaignNodeDeletionHandler;
    @Inject
    private PermissionEvaluationService permissionService;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.campaign.TestSuite','READ')")
    public TestSuite getOne(long id) {
        return (TestSuite)this.testSuiteRepository.getOne(id);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#testSuiteId,'org.squashtest.tm.domain.campaign.TestSuite','READ')")
    public Page<IterationTestPlanItem> findTestPlan(long testSuiteId, Pageable pageable) {
        return this.itpiRepository.findAllByTestSuiteId(testSuiteId, pageable);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#iterationId,'org.squashtest.tm.domain.campaign.Iteration','WRITE')")
    public TestSuite addTestSuite(Long iterationId, TestSuiteDto testSuiteDto) {
        TestSuite testSuite = new TestSuite();
        testSuite.setName(testSuiteDto.getName());
        if (testSuiteDto.isHasDescription()) {
            testSuite.setDescription(testSuiteDto.getDescription());
        }
        this.customIterationModificationService.addTestSuite(iterationId.longValue(), testSuite);
        if (testSuiteDto.isHasListItpi()) {
            List listIdsItem = testSuiteDto.getListItpi().stream().map(IterationTestPlanItemDto::getId).collect(Collectors.toList());
            this.testSuiteTestPlanManagerService.bindTestPlan(testSuite.getId().longValue(), listIdsItem);
        }
        if (testSuiteDto.isHasCufs()) {
            List<CustomFieldValueDto> cufValuesDto = testSuiteDto.getCustomFields();
            this.customFieldValueHelper.patchCustomFieldValue((BoundEntity)testSuite, cufValuesDto);
        }
        return testSuite;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#testSuiteId,'org.squashtest.tm.domain.campaign.TestSuite','WRITE')")
    public TestSuite modifyTestSuite(TestSuiteDto testSuiteDto, Long testSuiteId) {
        TestSuite testSuite = this.testSuiteTestPlanManagerService.findTestSuite(testSuiteId.longValue());
        if (testSuiteDto.isHasDescription()) {
            testSuite.setDescription(testSuiteDto.getDescription());
        }
        if (testSuiteDto.isHasStatus()) {
            ExecutionStatus executionStatus = ExecutionStatus.valueOf((String)testSuiteDto.getStatus());
            testSuite.setExecutionStatus(executionStatus);
        }
        if (testSuiteDto.isHasCufs()) {
            List<CustomFieldValueDto> cufValuesDto = testSuiteDto.getCustomFields();
            this.customFieldValueHelper.patchCustomFieldValue((BoundEntity)testSuite, cufValuesDto);
        }
        return testSuite;
    }

    @Override
    public void deleteTestSuite(List<Long> testSuiteIds) {
        PermissionsUtils.checkPermission((PermissionEvaluationService)this.permissionService, testSuiteIds, (String)"DELETE", (String)TestSuite.class.getName());
        this.campaignNodeDeletionHandler.deleteSuites(testSuiteIds, false);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#idTestSuite,'org.squashtest.tm.domain.campaign.TestSuite','LINK')")
    public TestSuite detachTestPlanFromTestSuite(Long idTestSuite, List<Long> ids) {
        TestSuite testSuite = (TestSuite)this.testSuiteDao.getOne((Object)idTestSuite);
        this.testSuiteTestPlanManagerService.detachTestPlanFromTestSuite(ids, idTestSuite.longValue());
        return testSuite;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#idTestSuite,'org.squashtest.tm.domain.campaign.TestSuite','LINK')")
    public TestSuite attachTestPlanToTestSuite(Long idTestSuite, List<Long> ids) {
        TestSuite testSuite = (TestSuite)this.testSuiteDao.getOne((Object)idTestSuite);
        this.testSuiteTestPlanManagerService.bindTestPlan(testSuite.getId().longValue(), ids);
        return testSuite;
    }
}

