/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.lang.Wrapped;
import org.squashtest.tm.domain.IdCollector;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.plugin.rest.jackson.model.ActionTestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.CalledTestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetDto;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetParamValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.KeywordTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.KeywordTestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.ParentEntity;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementVersionDto;
import org.squashtest.tm.plugin.rest.jackson.model.ScriptedTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDtoVisitor;
import org.squashtest.tm.plugin.rest.repository.RestTestCaseRepository;
import org.squashtest.tm.plugin.rest.service.RestInternalCustomFieldValueUpdaterService;
import org.squashtest.tm.plugin.rest.service.RestRequirementVersionService;
import org.squashtest.tm.plugin.rest.service.RestTestCaseService;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.plugin.rest.service.impl.KeywordTestStepPatcher;
import org.squashtest.tm.plugin.rest.service.impl.TestCasePatcher;
import org.squashtest.tm.plugin.rest.validators.TestCasePatchValidator;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.repository.InfoListItemDao;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;

@Service
@Transactional
public class RestTestCaseServiceImpl
implements RestTestCaseService {
    @Inject
    private TestCasePatcher testCasePatcher;
    @Inject
    private KeywordTestStepPatcher keywordTestStepPatcher;
    @Inject
    private InfoListItemDao infoListItemDao;
    @Inject
    private TestCaseModificationService testCaseModificationService;
    @Inject
    private VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    @Inject
    private RestRequirementVersionService requirementVersionService;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private RestTestCaseRepository dao;
    @Inject
    private ParameterModificationService parameterModificationService;
    @Inject
    private TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    @Inject
    private RestInternalCustomFieldValueUpdaterService internalCufService;
    @Inject
    private CustomFieldValueHelper customFieldValueConverter;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private TestCasePatchValidator testCasePatchValidator;
    @Inject
    private MessageSource messageSource;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public TestCase getOne(Long id) {
        return this.testCaseModificationService.findById(id.longValue());
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCase> getAllReadableTestCases(Pageable pageable) {
        Collection<Long> ids = this.getAllProjectIds();
        if (ids.isEmpty()) {
            return new PageImpl(Collections.emptyList(), pageable, 0L);
        }
        return this.dao.findAllInProjects(ids, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#tcid,'org.squashtest.tm.domain.testcase.TestCase' , 'READ')")
    public Page<TestStep> getTestCaseSteps(long tcid, Pageable pageable) {
        return this.dao.findTestCaseSteps(tcid, pageable);
    }

    @Override
    public TestCase createTestCase(TestCaseDto testCaseDto) throws InvocationTargetException, IllegalAccessException {
        String testCaseName = testCaseDto.getName();
        TestCase testCase = TestCaseDto.convertDto(testCaseDto);
        testCase.setName(testCaseName);
        this.fillDefaultValues(testCaseDto);
        this.testCasePatcher.patch(testCase, testCaseDto);
        this.addToParent(testCaseDto, testCase);
        this.entityManager.persist((Object)testCase);
        this.entityManager.flush();
        this.createSteps(testCaseDto, testCase);
        this.createParameters(testCaseDto, testCase);
        this.createDatasets(testCaseDto, testCase);
        this.addOrMergeVerifiedRequirements(testCaseDto, testCase);
        return testCase;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE')")
    public TestCase patchTestCase(TestCaseDto testCasePatch, long id) {
        TestCase testCase = this.dao.retrieveById(id);
        if (StringUtils.isNotBlank((CharSequence)testCasePatch.getName())) {
            this.testCaseModificationService.rename(testCase.getId().longValue(), testCasePatch.getName());
        }
        this.testCasePatcher.patch(testCase, testCasePatch);
        this.patchScriptIfExisted(testCasePatch, testCase);
        this.internalCufService.mergeCustomFields((BoundEntity)testCase, testCasePatch.getCustomFields());
        return testCase;
    }

    private void patchScriptIfExisted(final TestCaseDto testCasePatch, TestCase testCase) {
        TestCaseVisitor testCaseVisitor = new TestCaseVisitor(){

            public void visit(TestCase testCase) {
            }

            public void visit(KeywordTestCase keywordTestCase) {
            }

            public void visit(ScriptedTestCase scriptedTestCase) {
                final Wrapped scriptWrapped = new Wrapped(null);
                TestCaseDtoVisitor dtoVisitor = new TestCaseDtoVisitor(){

                    @Override
                    public void visit(TestCaseDto testCaseDto) {
                    }

                    @Override
                    public void visit(ScriptedTestCaseDto scriptedTestCaseDto) {
                        scriptWrapped.setValue((Object)scriptedTestCaseDto.getScript());
                    }

                    @Override
                    public void visit(KeywordTestCaseDto keywordTestCaseDto) {
                    }
                };
                testCasePatch.accept(dtoVisitor);
                String newScript = (String)scriptWrapped.getValue();
                if (newScript != null) {
                    scriptedTestCase.setScript(newScript);
                }
            }
        };
        testCase.accept(testCaseVisitor);
    }

    @Override
    public List<String> deleteTestCase(List<Long> testCaseIds, Boolean dryRun, Locale locale) {
        PermissionsUtils.checkPermission((PermissionEvaluationService)this.permissionService, testCaseIds, (String)"DELETE", (String)TestCase.class.getName());
        List<SuppressionPreviewReport> reports = this.testCasePatchValidator.simulationDelete(testCaseIds);
        if (dryRun == null || !dryRun.booleanValue()) {
            this.testCaseLibraryNavigationService.deleteNodes(testCaseIds);
        }
        ArrayList<String> reportMessages = new ArrayList<String>(reports.size());
        for (SuppressionPreviewReport report : reports) {
            reportMessages.add(report.toString(this.messageSource, locale));
        }
        return reportMessages;
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCase> getAllStandardTestCases(Pageable paging) {
        Collection<Long> ids = this.getAllProjectIds();
        if (ids.isEmpty()) {
            return new PageImpl(Collections.emptyList(), paging, 0L);
        }
        return this.dao.findAllStandardTestCasesInProject(ids, paging);
    }

    private Collection<Long> getAllProjectIds() {
        List projects = this.projectFinder.findAllReadable();
        return CollectionUtils.collect((Collection)projects, (Transformer)new IdCollector());
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCase> getAllScriptedTestCases(Pageable paging) {
        Collection<Long> ids = this.getAllProjectIds();
        if (ids.isEmpty()) {
            return new PageImpl(Collections.emptyList(), paging, 0L);
        }
        return this.dao.findAllScriptedTestCasesInProject(ids, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCase> getAllKeywordTestCases(Pageable paging) {
        Collection<Long> ids = this.getAllProjectIds();
        if (ids.isEmpty()) {
            return new PageImpl(Collections.emptyList(), paging, 0L);
        }
        return this.dao.findAllKeywordTestCasesInProject(ids, paging);
    }

    private void fillDefaultValues(TestCaseDto testCaseDto) {
        InfoListItem nature;
        Project project = testCaseDto.getProject();
        if (testCaseDto.getNature() == null) {
            nature = this.infoListItemDao.findDefaultTestCaseNature(project.getId().longValue());
            testCaseDto.setNature(nature);
        }
        if (testCaseDto.getType() == null) {
            nature = this.infoListItemDao.findDefaultTestCaseType(project.getId().longValue());
            testCaseDto.setType(nature);
        }
    }

    private void addToParent(TestCaseDto testCaseDto, TestCase testCase) {
        ParentEntity parent = testCaseDto.getParent();
        switch (parent.getRestType()) {
            case PROJECT: {
                this.addTestCaseToLibrary(testCase, testCaseDto, parent);
                break;
            }
            case TEST_CASE_FOLDER: {
                this.addTestCaseToFolder(testCase, testCaseDto, parent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Programmatic error : Rest type " + (Object)((Object)parent.getRestType()) + "is not a valid parent. You should validate this before.");
            }
        }
    }

    private void addTestCaseToFolder(TestCase testCase, TestCaseDto testCaseDto, ParentEntity parent) {
        TestCaseFolder testCaseFolder = (TestCaseFolder)this.entityManager.find(TestCaseFolder.class, (Object)parent.getId());
        if (testCaseFolder == null) {
            throw new IllegalArgumentException("Programmatic error : test case folder with id " + parent.getId() + "is unknown. You should validate this before.");
        }
        Map<Long, RawValue> customFieldMap = this.customFieldValueConverter.convertCustomFieldDtoToMap(testCaseDto.getCustomFields());
        this.testCaseLibraryNavigationService.addTestCaseToFolder(testCaseFolder.getId().longValue(), testCase, customFieldMap, null, new ArrayList());
    }

    private void addTestCaseToLibrary(TestCase testCase, TestCaseDto testCaseDto, ParentEntity parent) {
        Project project = (Project)this.entityManager.find(Project.class, (Object)parent.getId());
        if (project == null) {
            throw new IllegalArgumentException("Programmatic error : project with id " + parent.getId() + "is unknown. You should validate this before.");
        }
        Map<Long, RawValue> customFieldMap = this.customFieldValueConverter.convertCustomFieldDtoToMap(testCaseDto.getCustomFields());
        this.testCaseLibraryNavigationService.addTestCaseToLibrary(project.getTestCaseLibrary().getId().longValue(), testCase, customFieldMap, null, new ArrayList());
    }

    private void createDatasetParamValues(TestCase testCase, DatasetDto datasetDto, Dataset newDataset) {
        Set<DatasetParamValueDto> datasetParamValues = datasetDto.getValueDtos();
        List parameters = this.parameterModificationService.findAllParameters(testCase.getId().longValue());
        for (Parameter param : parameters) {
            String newValue = "";
            for (DatasetParamValueDto valueDto : datasetParamValues) {
                if (!valueDto.getParameterName().equals(param.getName())) continue;
                newValue = valueDto.getValue();
                datasetParamValues.remove(valueDto);
                break;
            }
            new DatasetParamValue(param, newDataset, newValue);
        }
        if (!datasetParamValues.isEmpty()) {
            throw new IllegalArgumentException("Error in parameter_values : parameter name '" + datasetParamValues.iterator().next().getParameterName() + "' must exist and be posted only once.");
        }
    }

    private void createParameters(TestCaseDto testCaseDto, TestCase testCase) {
        if (testCaseDto.getParameters() == null) {
            return;
        }
        for (Parameter parameter : testCaseDto.getParameters()) {
            Parameter detachedCopy = parameter.detachedCopy();
            detachedCopy.setTestCase(testCase);
        }
    }

    private void createSteps(TestCaseDto testCaseDto, TestCase testCase) {
        if (testCaseDto.getSteps() == null) {
            return;
        }
        List<TestStepDto> stepDtos = testCaseDto.getSteps();
        for (TestStepDto stepDto : stepDtos) {
            this.createStep(testCase, stepDto);
        }
    }

    private void createStep(final TestCase testCase, TestStepDto stepDto) {
        final TestStep testStep = TestStepDto.convertDto(stepDto);
        testStep.setTestCase(testCase);
        TestStepDtoVisitor visitor = new TestStepDtoVisitor(){

            @Override
            public void visit(ActionTestStepDto actionTestStepDto) {
                List<CustomFieldValueDto> customFieldValueDtos = actionTestStepDto.getCustomFields();
                Map<Long, RawValue> customFieldRawValues = RestTestCaseServiceImpl.this.customFieldValueConverter.convertCustomFieldDtoToMap(customFieldValueDtos);
                RestTestCaseServiceImpl.this.testCaseModificationService.addActionTestStep(testCase.getId().longValue(), (ActionTestStep)testStep, customFieldRawValues);
            }

            @Override
            public void visit(CalledTestStepDto calledTestStepDto) {
                CallTestStep callTestStep = (CallTestStep)testStep;
                testCase.addStep((TestStep)callTestStep);
            }

            @Override
            public void visit(KeywordTestStepDto keywordTestStepDto) {
                KeywordTestStep createdKeywordTestStep = RestTestCaseServiceImpl.this.testCaseModificationService.addKeywordTestStep(testCase.getId().longValue(), keywordTestStepDto.getKeyword().name(), keywordTestStepDto.getAction());
                RestTestCaseServiceImpl.this.keywordTestStepPatcher.patch(createdKeywordTestStep, keywordTestStepDto);
            }
        };
        stepDto.accept(visitor);
    }

    private void createDatasets(TestCaseDto testCaseDto, TestCase testCase) {
        if (testCaseDto.getDatasets() == null) {
            return;
        }
        for (DatasetDto dataset : testCaseDto.getDatasets()) {
            if (!DatasetDto.class.isAssignableFrom(dataset.getClass())) continue;
            DatasetDto datasetDto = dataset;
            Dataset newDataset = new Dataset(datasetDto.getName(), testCase);
            this.createDatasetParamValues(testCase, datasetDto, newDataset);
        }
    }

    private void addOrMergeVerifiedRequirements(TestCaseDto testCaseDto, TestCase testCase) {
        if (testCaseDto.getVerifiedRequirements() == null) {
            return;
        }
        List<Long> reqVerIds = testCaseDto.getVerifiedRequirements().stream().map(RequirementVersionDto::getId).collect(Collectors.toList());
        List<Long> verifReqIds = this.requirementVersionService.findReqIdsByVersionIds(reqVerIds);
        this.verifiedRequirementsManagerService.addVerifiedRequirementsToTestCase(verifReqIds, testCase.getId().longValue());
    }
}

