/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.IdCollector;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.NewRequirementVersionDto;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.plugin.rest.jackson.model.ParentEntity;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementDto;
import org.squashtest.tm.plugin.rest.repository.RestRequirementRepository;
import org.squashtest.tm.plugin.rest.repository.RestRequirementSyncExtenderRepository;
import org.squashtest.tm.plugin.rest.repository.RestRequirementVersionRepository;
import org.squashtest.tm.plugin.rest.service.RestRequirementVersionService;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.plugin.rest.service.impl.RequirementVersionPatcher;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;

@Service
@Transactional
public class RestRequirementVersionServiceImpl
implements RestRequirementVersionService {
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private RequirementVersionManagerService service;
    @Inject
    private RestRequirementRepository reqDao;
    @Inject
    private RestRequirementVersionRepository reqVerRepository;
    @Inject
    private RestRequirementSyncExtenderRepository syncExtenderDao;
    @Inject
    private RequirementLibraryNavigationService requirementLibraryNavigationService;
    @Inject
    private CustomFieldValueHelper customFieldValueConverter;
    @Inject
    private RestRequirementRepository restRequirementRepository;
    @Inject
    private RequirementVersionPatcher requirementVersionPatcher;
    @Inject
    private RequirementVersionManagerService requirementVersionManager;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    @Transactional(readOnly=true)
    public Page<Requirement> findAllReadable(Pageable paging) {
        List projects = this.projectFinder.findAllReadable();
        Collection ids = CollectionUtils.collect((Collection)projects, (Transformer)new IdCollector());
        if (ids.isEmpty()) {
            return new PageImpl(Collections.emptyList(), paging, 0L);
        }
        return this.reqDao.findAllInProjects(ids, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Requirement findRequirement(long requirementId) {
        return this.service.findRequirementById(requirementId);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#requirementId,'org.squashtest.tm.domain.requirement.Requirement' , 'READ')")
    public Page<Requirement> findRequirementChildren(long requirementId, Pageable paging) {
        return this.reqDao.findRequirementChildren(requirementId, paging);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#requirementId,'org.squashtest.tm.domain.requirement.Requirement' , 'READ')")
    public Page<Requirement> findRequirementAllChildren(long requirementId, Pageable paging) {
        return this.reqDao.findRequirementAllChildren(requirementId, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public RequirementVersion findRequirementVersion(long versionId) {
        return this.service.findById(versionId);
    }

    @Override
    public Requirement createRequirement(RequirementDto requirementDto) {
        NewRequirementVersionDto newRequirementVersionDto = this.convertRequirementDtoToNewRequirementVersionDto(requirementDto);
        return this.addToParent(requirementDto, newRequirementVersionDto);
    }

    @Override
    public void deleteRequirements(List<Long> reqIds) {
        this.requirementLibraryNavigationService.deleteNodes(reqIds);
    }

    @Override
    @Transactional(readOnly=true)
    @PostFilter(value="hasPermission(filterObject, 'READ') or hasRole('ROLE_ADMIN')")
    public List<Requirement> findSynchronizedRequirementsBy(String remoteKey, String serverName) {
        Collection<RequirementSyncExtender> extenders = this.syncExtenderDao.findAllByRemoteReqIdAndServerName(remoteKey, serverName);
        return extenders.stream().map(ex -> ex.getRequirement()).collect(Collectors.toList());
    }

    @Override
    public List<Long> findReqIdsByVersionIds(List<Long> versionIds) {
        return this.reqVerRepository.findRequirementIdsByRequirementVersionIds(versionIds);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#requirementId,'org.squashtest.tm.domain.requirement.Requirement' , 'WRITE')")
    public Requirement modifyRequirement(RequirementDto requirementDto, Long requirementId) {
        Requirement requirement = (Requirement)this.restRequirementRepository.getOne(requirementId);
        RequirementVersion reqVersion = requirement.getCurrentVersion();
        this.requirementVersionPatcher.patch(reqVersion, requirementDto.getCurrentVersion());
        if (requirementDto.getCurrentVersion().isHasCufs()) {
            this.requirementVersionPatcher.patchCustomFieldValue(requirementDto.getCurrentVersion(), reqVersion);
        }
        return requirement;
    }

    private Requirement addToParent(RequirementDto requirementDto, NewRequirementVersionDto newRequirementVersionDto) {
        Requirement requirement;
        ParentEntity parent = requirementDto.getParent();
        switch (parent.getRestType()) {
            case PROJECT: {
                requirement = this.addRequirementToLibrary(newRequirementVersionDto, parent);
                break;
            }
            case REQUIREMENT_FOLDER: {
                requirement = this.addRequirementToFolder(newRequirementVersionDto, parent);
                break;
            }
            case REQUIREMENT: {
                requirement = this.addRequirementToRequirement(newRequirementVersionDto, parent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Programmatic error : Rest type " + (Object)((Object)parent.getRestType()) + "is not a valid parent. You should validate this before.");
            }
        }
        return requirement;
    }

    private Requirement addRequirementToLibrary(NewRequirementVersionDto newRequirementVersionDto, ParentEntity parent) {
        Project project = (Project)this.entityManager.find(Project.class, (Object)parent.getId());
        if (project != null) {
            return this.requirementLibraryNavigationService.addRequirementToRequirementLibrary(project.getRequirementLibrary().getId().longValue(), newRequirementVersionDto, new ArrayList());
        }
        throw new IllegalArgumentException("Programmatic error : project with id " + parent.getId() + "is unknown. You should validate this before.");
    }

    private Requirement addRequirementToFolder(NewRequirementVersionDto newRequirementVersionDto, ParentEntity parent) {
        RequirementFolder requirementFolder = (RequirementFolder)this.entityManager.find(RequirementFolder.class, (Object)parent.getId());
        if (requirementFolder != null) {
            return this.requirementLibraryNavigationService.addRequirementToRequirementFolder(requirementFolder.getId().longValue(), newRequirementVersionDto, new ArrayList());
        }
        throw new IllegalArgumentException("Programmatic error : requirement folder with id " + parent.getId() + "is unknown. You should validate this before.");
    }

    private Requirement addRequirementToRequirement(NewRequirementVersionDto newRequirementVersionDto, ParentEntity parent) {
        Requirement req = (Requirement)this.entityManager.find(Requirement.class, (Object)parent.getId());
        if (req != null) {
            return this.requirementLibraryNavigationService.addRequirementToRequirement(req.getId().longValue(), newRequirementVersionDto, new ArrayList());
        }
        throw new IllegalArgumentException("Programmatic error : requirement folder with id " + parent.getId() + "is unknown. You should validate this before.");
    }

    private NewRequirementVersionDto convertRequirementDtoToNewRequirementVersionDto(RequirementDto requirementDto) {
        NewRequirementVersionDto newRequirementVersionDto = new NewRequirementVersionDto();
        Map<Long, RawValue> customFieldMap = this.customFieldValueConverter.convertCustomFieldDtoToMap(requirementDto.getCustomFields());
        newRequirementVersionDto.setName(requirementDto.getName());
        newRequirementVersionDto.setReference(requirementDto.getCurrentVersion().getReference());
        newRequirementVersionDto.setCategory(requirementDto.getCurrentVersion().getCategory().getCode());
        newRequirementVersionDto.setCriticality(requirementDto.getCurrentVersion().getCriticality());
        newRequirementVersionDto.setDescription(requirementDto.getDescription());
        newRequirementVersionDto.setCustomFields(customFieldMap);
        return newRequirementVersionDto;
    }
}

