/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.IdCollector;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.ParentEntity;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementFolderDto;
import org.squashtest.tm.plugin.rest.repository.RestRequirementFolderRepository;
import org.squashtest.tm.plugin.rest.service.RestRequirementFolderService;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.library.FolderModificationService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;

@Service
@Transactional
public class RestRequirementFolderServiceImpl
implements RestRequirementFolderService {
    @Inject
    @Qualifier(value="squashtest.tm.service.RequirementFolderModificationService")
    private FolderModificationService<RequirementFolder> nativeService;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private RestRequirementFolderRepository dao;
    @Inject
    private RequirementLibraryNavigationService requirementLibraryNavigationService;
    @Inject
    private PrivateCustomFieldValueService privateCustomFieldValueService;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private CustomFieldValueHelper customFieldValueHelper;

    @Override
    @Transactional(readOnly=true)
    public RequirementFolder getOne(Long id) {
        return (RequirementFolder)this.nativeService.findFolder(id.longValue());
    }

    @Override
    @Transactional(readOnly=true)
    public Page<RequirementFolder> findAllReadable(Pageable pageable) {
        List projects = this.projectFinder.findAllReadable();
        Collection ids = CollectionUtils.collect((Collection)projects, (Transformer)new IdCollector());
        if (ids.isEmpty()) {
            return new PageImpl(Collections.emptyList(), pageable, 0L);
        }
        return this.dao.findAllInProjects(ids, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#folderId,'org.squashtest.tm.domain.requirement.RequirementFolder' , 'READ')")
    public Page<RequirementLibraryNode<?>> findFolderContent(long folderId, Pageable pageable) {
        return this.dao.findFolderContent(folderId, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#folderId,'org.squashtest.tm.domain.requirement.RequirementFolder' , 'READ')")
    public Page<RequirementLibraryNode<?>> findFolderAllContent(long folderId, Pageable pageable) {
        return this.dao.findFolderAllContent(folderId, pageable);
    }

    @Override
    public RequirementFolder addRequirementFolder(RequirementFolderDto folderDto) throws InvocationTargetException, IllegalAccessException {
        RequirementFolder folder = new RequirementFolder();
        folder.setName(folderDto.getName());
        folder.setDescription(folderDto.getDescription());
        this.addToParent(folderDto, folder);
        if (folderDto.getCustomFields() != null) {
            List<CustomFieldValueDto> listCufsDto = folderDto.getCustomFields();
            this.customFieldValueHelper.patchCustomFieldValue((BoundEntity)folder, listCufsDto);
        }
        this.entityManager.persist((Object)folder);
        this.entityManager.flush();
        return folder;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.requirement.RequirementFolder' , 'WRITE')")
    public RequirementFolder patchRequirementFolder(RequirementFolderDto folderPatch, long id) {
        RequirementFolder folder = this.getOne(id);
        folder.setName(folderPatch.getName());
        folder.setDescription(folderPatch.getDescription());
        if (folderPatch.getCustomFields() != null) {
            List<CustomFieldValueDto> listCufsDto = folderPatch.getCustomFields();
            this.customFieldValueHelper.patchCustomFieldValue((BoundEntity)folder, listCufsDto);
        }
        return folder;
    }

    @Override
    public void deleteFolder(List<Long> folderIds) {
        this.requirementLibraryNavigationService.deleteNodes(folderIds);
    }

    private void addToParent(RequirementFolderDto folderDto, RequirementFolder folder) {
        ParentEntity parent = folderDto.getParent();
        switch (parent.getRestType()) {
            case PROJECT: {
                this.addRequirementFolderToLibrary(folder, folderDto, parent);
                break;
            }
            case REQUIREMENT_FOLDER: {
                this.addRequirementFolderToFolder(folder, folderDto, parent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Programmatic error : Rest type " + (Object)((Object)parent.getRestType()) + "is not a valid parent. You should validate this before.");
            }
        }
    }

    private void addRequirementFolderToFolder(RequirementFolder folder, RequirementFolderDto folderDto, ParentEntity parent) {
        RequirementFolder requirementFolder = (RequirementFolder)this.entityManager.find(RequirementFolder.class, (Object)parent.getId());
        if (requirementFolder == null) {
            throw new IllegalArgumentException("Programmatic error : test case folder with id " + parent.getId() + "is unknown. You should validate this before.");
        }
        this.requirementLibraryNavigationService.addFolderToFolder(requirementFolder.getId().longValue(), (Folder)folder);
    }

    private void addRequirementFolderToLibrary(RequirementFolder folder, RequirementFolderDto folderDto, ParentEntity parent) {
        Project project = (Project)this.entityManager.find(Project.class, (Object)parent.getId());
        if (project == null) {
            throw new IllegalArgumentException("Programmatic error : project with id " + parent.getId() + "is unknown. You should validate this before.");
        }
        this.requirementLibraryNavigationService.addFolderToLibrary(project.getRequirementLibrary().getId().longValue(), (Folder)folder);
    }
}

