/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyProjectPermissionsBean;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectCopyParameterDto;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDto;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectDto;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectTemplateDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyPermission;
import org.squashtest.tm.plugin.rest.repository.RestGenericProjectRepository;
import org.squashtest.tm.plugin.rest.service.RestPartyService;
import org.squashtest.tm.plugin.rest.service.RestProjectService;
import org.squashtest.tm.security.acls.PermissionGroup;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.project.ProjectManagerService;
import org.squashtest.tm.service.project.ProjectTemplateManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class RestProjectServiceImpl
implements RestProjectService {
    private static final String NAMESPACE = "squashtest.acl.group.tm.";
    @Inject
    private RestGenericProjectRepository dao;
    @Inject
    private PermissionEvaluationService permService;
    @Inject
    private GenericProjectManagerService genericProjectManager;
    @Inject
    private ProjectManagerService projectManager;
    @Inject
    private ProjectTemplateManagerService projectTemplateManagerService;
    @Inject
    private RestPartyService restPartyService;

    @Override
    @PreAuthorize(value="hasPermission(#id, 'org.squashtest.tm.domain.project.Project' , 'MANAGEMENT') or hasPermission(#id, 'org.squashtest.tm.domain.project.ProjectTemplate' , 'MANAGEMENT') or hasRole('ROLE_ADMIN')")
    public GenericProject getOne(long id) {
        return this.dao.getOne(id);
    }

    @Override
    public GenericProject getOneByName(String projectName) {
        GenericProject project = this.dao.getOneByName(projectName);
        if (Objects.isNull(project)) {
            throw new EntityNotFoundException("Unable to find org.squashtest.tm.domain.project.GenericProject with name " + projectName);
        }
        if (!this.permService.hasPermissionOnObject("MANAGEMENT", (Object)project) && !this.permService.hasRole("ROLE_ADMIN")) {
            throw new AccessDeniedException("access is denied");
        }
        return project;
    }

    @Override
    @Transactional(readOnly=true)
    public Page<GenericProject> findAllReadable(Pageable pageable) {
        return this.dao.findAll(pageable);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<RequirementLibraryNode> findRequirementLibraryAllContent(long id, Pageable paging) {
        this.checkReadOnRequirements(id);
        return this.dao.findRequirementLibraryAllContent(id, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<RequirementLibraryNode> findRequirementLibraryRootContent(long id, Pageable paging) {
        this.checkReadOnRequirements(id);
        return this.dao.findRequirementLibraryRootContent(id, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCaseLibraryNode> findTestCaseLibraryAllContent(long id, Pageable paging) {
        this.checkReadOnTestCases(id);
        return this.dao.findTestCaseLibraryAllContent(id, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCaseLibraryNode> findTestCaseLibraryRootContent(long id, Pageable paging) {
        this.checkReadOnTestCases(id);
        return this.dao.findTestCaseLibraryRootContent(id, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<CampaignLibraryNode> findCampaignLibraryAllContent(long id, Pageable paging) {
        this.checkReadOnCampaigns(id);
        return this.dao.findCampaignLibraryAllContent(id, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<CampaignLibraryNode> findCampaignLibraryRootContent(long id, Pageable paging) {
        this.checkReadOnCampaigns(id);
        return this.dao.findCampaignLibraryRootContent(id, paging);
    }

    @Override
    public GenericProject createGenericProject(GenericProjectDto genericProjectDto) {
        final GenericProject genericProject = GenericProjectDto.convertDto(genericProjectDto);
        GenericProjectDtoVisitor visitor = new GenericProjectDtoVisitor(){

            @Override
            public void visit(ProjectDto projectDto) {
                if (projectDto.getTemplateId() != null) {
                    RestProjectServiceImpl.this.projectManager.addProjectFromTemplate((Project)genericProject, projectDto.getTemplateId().longValue(), GenericProjectCopyParameterDto.convertDto(projectDto.getParams()));
                } else {
                    RestProjectServiceImpl.this.genericProjectManager.persist(genericProject);
                }
            }

            @Override
            public void visit(ProjectTemplateDto projectTemplateDto) {
                if (projectTemplateDto.getProjectId() != null) {
                    RestProjectServiceImpl.this.projectTemplateManagerService.addTemplateFromProject((ProjectTemplate)genericProject, projectTemplateDto.getProjectId().longValue(), GenericProjectCopyParameterDto.convertDto(projectTemplateDto.getParams()));
                } else {
                    RestProjectServiceImpl.this.genericProjectManager.persist(genericProject);
                }
            }
        };
        genericProjectDto.accept(visitor);
        return genericProject;
    }

    @Override
    public RestPartyPermission findAllPermissionsByProjectId(long projectId) {
        List beanList = this.genericProjectManager.findPartyPermissionsBeansByProject(projectId);
        RestPartyPermission permissions = new RestPartyPermission();
        for (PartyProjectPermissionsBean item : beanList) {
            String groupName = item.getPermissionGroup().getSimpleName();
            if (groupName.matches("advanceTester")) {
                groupName = "advancedTester";
            }
            Party target = this.restPartyService.findById(item.getParty().getId());
            ArrayList<Party> targetList = (ArrayList<Party>)permissions.get(groupName);
            if (targetList == null) {
                targetList = new ArrayList<Party>();
                targetList.add(target);
                permissions.put(groupName, targetList);
                continue;
            }
            targetList.add(target);
        }
        return permissions;
    }

    @Override
    public RestPartyPermission buildPartyPermissionDataModel(String permissionGroup, List<Long> partyIds) {
        ArrayList<Party> parties = new ArrayList<Party>();
        for (Long partyId : partyIds) {
            parties.add(this.restPartyService.findById(partyId));
        }
        RestPartyPermission permissions = new RestPartyPermission();
        permissions.put(permissionGroup, parties);
        return permissions;
    }

    @Override
    public void addNewPermissionToProject(long userId, long projectId, String permissionGroup) {
        this.genericProjectManager.addNewPermissionToProject(userId, projectId, NAMESPACE + permissionGroup);
    }

    @Override
    public List<PermissionGroup> findAllPossiblePermission() {
        return this.genericProjectManager.findAllPossiblePermission();
    }

    @Override
    public Page<Requirement> findRequirementsByProject(long projectId, Pageable paging) {
        return this.dao.findAllRequirementByProjectId(projectId, paging);
    }

    @Override
    public Page<TestCase> findTestCasesByProject(long projectId, Pageable paging) {
        return this.dao.findAllTestCaseByProjectId(projectId, paging);
    }

    @Override
    public Page<Campaign> findCampaignsByProject(long projectId, Pageable paging) {
        return this.dao.findAllCampaignByProjectId(projectId, paging);
    }

    @Override
    public void deletePartyFromProject(Long partyId, long projectId) {
        this.genericProjectManager.removeProjectPermission(partyId.longValue(), projectId);
    }

    private void checkReadOnRequirements(long projectId) {
        GenericProject p = this.dao.getOne(projectId);
        if (p == null) {
            throw new EntityNotFoundException();
        }
        if (!this.permService.canRead((Object)p.getRequirementLibrary())) {
            throw new EntityNotFoundException("access is denied");
        }
    }

    private void checkReadOnTestCases(long projectId) {
        GenericProject p = this.dao.getOne(projectId);
        if (p == null) {
            throw new EntityNotFoundException();
        }
        if (!this.permService.canRead((Object)p.getTestCaseLibrary())) {
            throw new AccessDeniedException("access is denied");
        }
    }

    private void checkReadOnCampaigns(long projectId) {
        GenericProject p = this.dao.getOne(projectId);
        if (p == null) {
            throw new EntityNotFoundException();
        }
        if (!this.permService.canRead((Object)p.getCampaignLibrary())) {
            throw new AccessDeniedException("access is denied");
        }
    }
}

