/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyVisitor;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.jackson.model.PartyDto;
import org.squashtest.tm.plugin.rest.jackson.model.PartyDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.TeamDto;
import org.squashtest.tm.plugin.rest.jackson.model.UserDto;
import org.squashtest.tm.plugin.rest.repository.RestPartyRepository;
import org.squashtest.tm.plugin.rest.repository.RestTeamRepository;
import org.squashtest.tm.plugin.rest.repository.RestUserRepository;
import org.squashtest.tm.plugin.rest.service.RestPartyService;
import org.squashtest.tm.plugin.rest.service.impl.UserPatcher;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;
import org.squashtest.tm.service.user.TeamModificationService;
import org.squashtest.tm.service.user.UserManagerService;

@Service
@Transactional
public class RestPartyServiceImpl
implements RestPartyService {
    @Inject
    private UserManagerService userManagerService;
    @Inject
    private TeamModificationService teamModificationService;
    @Inject
    private GenericProjectManagerService projectManagerService;
    @Inject
    private ObjectAclService aclService;
    @Inject
    private RestTeamRepository teamDao;
    @Inject
    private RestUserRepository userDao;
    @Inject
    private RestPartyRepository partyRepository;
    @Inject
    private UserPatcher userPatcher;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public Party findById(long id) {
        Optional party = this.partyRepository.findById(id);
        if (!party.isPresent()) {
            throw new EntityNotFoundException("The user/team with id: " + id + " does not exist.");
        }
        final Party[] result = new Party[1];
        PartyVisitor visitor = new PartyVisitor(){

            public void visit(User user) {
                result[0] = user;
            }

            public void visit(Team team) {
                result[0] = team;
            }
        };
        ((Party)party.get()).accept(visitor);
        return result[0];
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public Party getOne(long id) {
        Party party = this.projectManagerService.findPartyById(id);
        if (party == null) {
            throw new EntityNotFoundException("The user/team with id: " + id + " does not exist.");
        }
        return party;
    }

    @Override
    public User findUserByLogin(String login) {
        return this.userManagerService.findByLogin(login);
    }

    @Override
    @PostAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<User> findAllUsers(Pageable pageable) {
        return this.userDao.findAll(pageable);
    }

    @Override
    @PostAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<Team> findAllTeams(Pageable pageable) {
        return this.teamDao.findAll(pageable);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<Team> findTeamsByUser(long userId, Pageable pageable) {
        return this.teamDao.findTeamsByUserId(userId, pageable);
    }

    @Override
    public Party createParty(PartyDto partyDto) {
        final Party[] parties = new Party[1];
        PartyDtoVisitor visitor = new PartyDtoVisitor(){

            @Override
            public void visit(UserDto userDto) {
                User user = new User();
                user.setFirstName(userDto.getFirstName());
                user.setLastName(userDto.getLastName());
                user.setLogin(userDto.getLogin());
                user.setEmail(userDto.getEmail());
                user.setActive(userDto.getActive());
                RestPartyServiceImpl.this.userManagerService.addUser(user, userDto.getGroupId().longValue(), userDto.getPassword());
                parties[0] = user;
            }

            @Override
            public void visit(TeamDto teamDto) {
                Team team = new Team();
                team.setName(teamDto.getName());
                team.setDescription(teamDto.getDescription());
                RestPartyServiceImpl.this.teamModificationService.persist(team);
                parties[0] = team;
            }
        };
        partyDto.accept(visitor);
        return parties[0];
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Party patchParty(PartyDto patch, final long id) {
        final Party party = this.findById(id);
        PartyDtoVisitor visitor = new PartyDtoVisitor(){

            @Override
            public void visit(UserDto userDto) {
                if (userDto.getPassword() != null) {
                    RestPartyServiceImpl.this.userManagerService.resetUserPassword(id, userDto.getPassword());
                }
                if (userDto.getLogin() != null) {
                    RestPartyServiceImpl.this.userManagerService.modifyUserLogin(id, userDto.getLogin());
                }
                if (userDto.getGroupId() != null) {
                    RestPartyServiceImpl.this.userManagerService.setUserGroupAuthority(id, userDto.getGroupId().longValue());
                }
                RestPartyServiceImpl.this.userPatcher.patch(party, userDto);
            }

            @Override
            public void visit(TeamDto teamDto) {
                if (teamDto.getName() != null) {
                    RestPartyServiceImpl.this.teamModificationService.changeName(id, teamDto.getName());
                }
                if (teamDto.getDescription() != null) {
                    RestPartyServiceImpl.this.teamModificationService.changeDescription(id, teamDto.getDescription());
                }
            }
        };
        patch.accept(visitor);
        return party;
    }

    @Override
    public void deleteUsers(List<Long> ids) {
        this.userManagerService.deleteUsers(ids);
    }

    @Override
    public void deleteTeams(List<Long> ids) {
        this.teamModificationService.deleteTeam(ids);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<User> findAllTeamMembers(long teamId, Pageable pageable) {
        return this.userDao.findMembersByTeamId(teamId, pageable);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void addMembersToTeam(long teamId, List<Long> userIds) {
        try {
            Team team = (Team)this.findById(teamId);
            List<User> users = this.userDao.findByIdIn(userIds);
            team.addMembers(users);
            userIds.forEach(userId -> this.aclService.updateDerivedPermissions(userId.longValue()));
        }
        catch (ClassCastException classCastException) {
            throw new EntityNotFoundException("The team with id: " + teamId + " does not exist.");
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void removeMembersFromTeam(long teamId, List<Long> userIds) {
        try {
            Team cfr_ignored_0 = (Team)this.findById(teamId);
            this.teamModificationService.removeMembers(teamId, userIds);
        }
        catch (ClassCastException classCastException) {
            throw new EntityNotFoundException("The team with id: " + teamId + " does not exist.");
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void addTeamsToUser(long userId, List<Long> teamIds) {
        try {
            User user = (User)this.findById(userId);
            List<Team> teams = this.teamDao.findByIdIn(teamIds);
            teams.forEach(team -> team.addMember(user));
            this.aclService.updateDerivedPermissions(userId);
        }
        catch (ClassCastException classCastException) {
            throw new EntityNotFoundException("The user with id: " + userId + " does not exist.");
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void disassociateUserFromTeams(long userId, List<Long> teamIds) {
        try {
            this.userManagerService.deassociateTeams(userId, teamIds);
        }
        catch (ClassCastException classCastException) {
            throw new EntityNotFoundException("The user with id: " + userId + " does not exist.");
        }
    }
}

