/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetDto;
import org.squashtest.tm.plugin.rest.jackson.model.IterationTestPlanItemDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.repository.RestExecutionRepository;
import org.squashtest.tm.plugin.rest.repository.RestIterationTestPlanItemRepository;
import org.squashtest.tm.plugin.rest.service.RestIterationTestPlanItemService;
import org.squashtest.tm.plugin.rest.validators.IterationTestPlanItemPostValidator;
import org.squashtest.tm.service.campaign.CustomIterationModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.UserDao;

@Service
@Transactional
public class RestIterationTestPlanItemServiceImpl
implements RestIterationTestPlanItemService {
    private static final String LINK_ITERATION_OR_ROLE_ADMIN = "hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')";
    private static final String ITERATION_ID = "iterationId";
    @Inject
    private RestIterationTestPlanItemRepository itpiRepository;
    @Inject
    private RestExecutionRepository executionRepository;
    @Inject
    private CustomIterationModificationService nativeService;
    @Inject
    private IterationTestPlanManagerService iterationTestPlanManagerService;
    @Inject
    private IterationTestPlanItemPostValidator iterationTestPlanItemPostValidator;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private DatasetDao datasetDao;
    @Inject
    private UserDao userDao;
    @Inject
    private IterationTestPlanDao iterationTestPlanDao;
    @Inject
    private IterationDao iterationDao;
    private Object object;
    private Object object1;
    private Object elt;

    @Override
    @PostAuthorize(value="hasPermission(returnObject , 'READ') or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public IterationTestPlanItem getOne(long id) {
        IterationTestPlanItem itpi = (IterationTestPlanItem)this.itpiRepository.getOne(id);
        if (itpi == null) {
            throw new EntityNotFoundException();
        }
        return itpi;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#itpiId, 'org.squashtest.tm.domain.campaign.IterationTestPlanItem', 'READ')")
    @Transactional(readOnly=true)
    public Page<Execution> findExecutions(long itpiId, Pageable pageable) {
        return this.executionRepository.findAllByTestPlan_Id(itpiId, pageable);
    }

    @Override
    public Execution createExecution(long itpiId) {
        return this.nativeService.addExecution(itpiId);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<IterationTestPlanItem> findItemsByCoveredRemoteRequirement(Pageable pageable, String remoteKey, String serverName) {
        return this.itpiRepository.findItemsByCoveredRemoteRequirement(remoteKey, serverName, pageable);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#testPlanId, 'org.squashtest.tm.domain.campaign.IterationTestPlanItem', 'WRITE')")
    public IterationTestPlanItem modifyIterationTestPlan(IterationTestPlanItemDto itpiDto, Long testPlanId) {
        User assignedTo;
        IterationTestPlanItem itpi = (IterationTestPlanItem)this.itpiRepository.getOne(testPlanId);
        Dataset ds = itpiDto.getReferencedDataset() != null ? (Dataset)this.datasetDao.getOne((Object)itpiDto.getReferencedDataset().getId()) : null;
        User user = assignedTo = itpiDto.getUser() != null ? this.userDao.findUserByLogin(itpiDto.getUser()) : null;
        if (itpiDto.isHasSetDataset()) {
            itpi.setReferencedDataset(ds);
        }
        if (itpiDto.isAssignedTo()) {
            itpi.setUser(assignedTo);
        }
        return itpi;
    }

    @Override
    public void deleteIterationTestPlan(List<Long> testPlanIds) {
        List<Couple<Long, Long>> listIds = this.itpiRepository.findIterationByIdItem(testPlanIds);
        Map mapItpi = listIds.stream().collect(Collectors.groupingBy(Couple::getA1, Collectors.mapping(Couple::getA2, Collectors.toList())));
        mapItpi.forEach((k, v) -> this.iterationTestPlanManagerService.removeTestPlansFromIteration(v, k.longValue()));
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')")
    public IterationTestPlanItem addIterationTestPlanItem(IterationTestPlanItemDto testPlanItemDto, long iterationId) {
        TestCaseDto referencedTcDTo = testPlanItemDto.getTestCaseDto();
        DatasetDto referencedDatasetDto = testPlanItemDto.getReferencedDataset();
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        TestCase testCase = (TestCase)this.testCaseDao.findById(referencedTcDTo.getId().longValue());
        String assignedTo = testPlanItemDto.getUser();
        User aTo = assignedTo != null ? this.userDao.findUserByLogin(assignedTo) : null;
        Dataset ds = referencedDatasetDto != null ? (Dataset)this.datasetDao.getOne((Object)referencedDatasetDto.getId()) : null;
        IterationTestPlanItem itp = new IterationTestPlanItem(testCase, ds, aTo);
        this.iterationTestPlanDao.save((Object)itp);
        iteration.addTestPlan(itp);
        return itp;
    }
}

