/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.plugin.rest.jackson.model.IterationDto;
import org.squashtest.tm.plugin.rest.repository.RestIterationRepository;
import org.squashtest.tm.plugin.rest.repository.RestIterationTestPlanItemRepository;
import org.squashtest.tm.plugin.rest.repository.RestTestSuiteRepository;
import org.squashtest.tm.plugin.rest.service.RestInternalCustomFieldValueUpdaterService;
import org.squashtest.tm.plugin.rest.service.RestIterationService;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.plugin.rest.service.impl.IterationPatcher;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.UserDao;

@Service
@Transactional
public class RestIterationServiceImpl
implements RestIterationService {
    @Inject
    private RestIterationRepository iterationRepository;
    @Inject
    private RestIterationTestPlanItemRepository itpiRepository;
    @Inject
    private RestTestSuiteRepository testSuiteRepository;
    @Inject
    private IterationPatcher iterationPatcher;
    @Inject
    private CustomFieldValueHelper customFieldValueConverter;
    @Inject
    private CampaignLibraryNavigationService campaignLibraryNavigationService;
    @Inject
    private IterationModificationService iterationModificationService;
    @Inject
    private RestInternalCustomFieldValueUpdaterService internalCufService;
    @Inject
    private IterationDao iterationDao;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private DatasetDao datasetDao;
    @Inject
    private UserDao userDao;
    @Inject
    private IterationTestPlanDao iterationTestPlanDao;

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#id, 'org.squashtest.tm.domain.campaign.Iteration', 'READ')")
    @Transactional(readOnly=true)
    public Iteration getOne(long id) {
        return (Iteration)this.iterationRepository.getOne(id);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'WRITE')")
    public Iteration createIteration(IterationDto iterationDto, Long campaignId) {
        Iteration iteration = new Iteration();
        iteration.setName(iterationDto.getName());
        this.iterationPatcher.patch(iteration, iterationDto);
        iteration.setActualStartAuto(iterationDto.isActualStartAuto());
        iteration.setActualEndAuto(iterationDto.isActualEndAuto());
        Map<Long, RawValue> customFieldRawValues = this.customFieldValueConverter.convertCustomFieldDtoToMap(iterationDto.getCustomFields());
        this.campaignLibraryNavigationService.addIterationToCampaign(iteration, campaignId.longValue(), iterationDto.isCopyCampaignExecutionPlan(), customFieldRawValues);
        this.fillTimePeriod(iterationDto, iteration.getId());
        return iteration;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')")
    public Iteration patchIteration(IterationDto patch, long iterationId) {
        Iteration iteration = this.getOne(iterationId);
        if (StringUtils.isNotBlank((CharSequence)patch.getName())) {
            this.iterationModificationService.rename(patch.getId().longValue(), patch.getName());
        }
        this.iterationPatcher.patch(iteration, patch);
        this.fillTimePeriod(patch, iteration.getId());
        this.internalCufService.mergeCustomFields((BoundEntity)iteration, patch.getCustomFields());
        return iteration;
    }

    @Override
    public void deleteIterationsByIds(List<Long> iterationIds) {
        this.campaignLibraryNavigationService.deleteIterations(iterationIds);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'READ')")
    @Transactional(readOnly=true)
    public Page<IterationTestPlanItem> findIterationTestPlan(long iterationId, Pageable pageable) {
        return this.itpiRepository.findAllByIteration_Id(iterationId, pageable);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'READ')")
    @Transactional(readOnly=true)
    public Page<TestSuite> findIterationTestSuite(long iterationId, Pageable pageable) {
        return this.testSuiteRepository.findAllByIteration_Id(iterationId, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    public Iteration getOneByName(String iterationName) {
        Iteration iteration = this.iterationRepository.getOneByName(iterationName);
        if (Objects.isNull(iteration)) {
            throw new EntityNotFoundException("Unable to find org.squashtest.tm.domain.campaign.Iteration with name " + iterationName);
        }
        return iteration;
    }

    private void fillTimePeriod(IterationDto iterationDto, long iterationId) {
        if (iterationDto.getScheduledStartDate() != null) {
            this.iterationModificationService.changeScheduledStartDate(iterationId, iterationDto.getScheduledStartDate());
        }
        if (iterationDto.getScheduledEndDate() != null) {
            this.iterationModificationService.changeScheduledEndDate(iterationId, iterationDto.getScheduledEndDate());
        }
        if (iterationDto.getActualStartDate() != null) {
            this.iterationModificationService.changeActualStartDate(iterationId, iterationDto.getActualStartDate());
        }
        if (iterationDto.getActualEndDate() != null) {
            this.iterationModificationService.changeActualEndDate(iterationId, iterationDto.getActualEndDate());
        }
    }
}

