/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import javax.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.bugtracker.IssueList;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.exception.IssueAlreadyBoundException;
import org.squashtest.tm.plugin.rest.core.utils.ExceptionUtils;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.repository.RestIssueRepository;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.execution.ExecutionProcessingService;
import org.squashtest.tm.service.internal.repository.BugTrackerBindingDao;

@Service
@Transactional
public class RestIssueServiceImpl
implements RestIssueService {
    @Inject
    private RestIssueRepository issueRepository;
    @Inject
    private RestIssueService restIssueService;
    @Inject
    private BugTrackerBindingDao bugTrackerBindingDao;
    @Inject
    private BugTrackersLocalService bugTrackersLocalService;
    @Inject
    private ExecutionProcessingService executionProcessingService;

    @Override
    @Transactional(readOnly=true)
    public Issue getOne(long id) {
        Issue issue = (Issue)this.issueRepository.getOne(id);
        if (issue == null) {
            throw ExceptionUtils.entityNotFoundException(Issue.class, (Long)id);
        }
        Execution testExec = new Execution();
        testExec.setDescription("llolololo");
        return issue;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#idExecution,'org.squashtest.tm.domain.execution.Execution' , 'WRITE')")
    public Issue attachIssue(IssueDto issueDto, Long idExecution) {
        Execution exc = this.executionProcessingService.findExecution(idExecution);
        IssueList issueList = exc.getIssueList();
        BugTracker bt = exc.getBugTracker();
        Issue issue = null;
        if (issueList.hasRemoteIssue(issueDto.getRemoteIssueId())) {
            throw new IssueAlreadyBoundException();
        }
        issue = new Issue();
        issue.setBugtracker(bt);
        issue.setRemoteIssueId(issueDto.getRemoteIssueId());
        issueList.addIssue(issue);
        this.issueRepository.save(issue);
        this.bugTrackersLocalService.findTestCaseRelatedToIssue(issue.getId());
        return issue;
    }
}

