/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import javax.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.plugin.rest.jackson.model.ExecutionStepAndCustomFields;
import org.squashtest.tm.plugin.rest.repository.RestExecutionStepRepository;
import org.squashtest.tm.plugin.rest.service.RestExecutionStepService;
import org.squashtest.tm.plugin.rest.service.RestInternalCustomFieldValueUpdaterService;
import org.squashtest.tm.service.execution.ExecutionProcessingService;

@Service
@Transactional
public class RestExecutionStepServiceImpl
implements RestExecutionStepService {
    @Inject
    private RestExecutionStepRepository dao;
    @Inject
    private ExecutionProcessingService executionProcessingService;
    @Inject
    private RestInternalCustomFieldValueUpdaterService internalCufService;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.execution.ExecutionStep' , 'READ')")
    public ExecutionStep getOne(long id) {
        return (ExecutionStep)this.dao.getOne(id);
    }

    @Override
    public void modifyExecutionStatus(Long executionStepId, ExecutionStatus status) {
        this.executionProcessingService.changeExecutionStepStatus(executionStepId, status);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#step.wrapped , 'EXECUTE')")
    public void updateStep(ExecutionStepAndCustomFields step) {
        this.internalCufService.mergeCustomFields(step);
        this.internalCufService.mergeDenormalizedFields(step);
    }
}

