/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.IdCollector;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignFolderDto;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.ParentEntity;
import org.squashtest.tm.plugin.rest.repository.RestCampaignFolderRepository;
import org.squashtest.tm.plugin.rest.service.RestCampaignFolderService;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.project.ProjectFinder;

@Service
@Transactional
public class RestCampaignFolderServiceImpl
implements RestCampaignFolderService {
    @Inject
    private RestCampaignFolderRepository dao;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private CustomFieldValueHelper customFieldValueHelper;
    @Inject
    private CampaignLibraryNavigationService campaignLibraryNavigationService;
    @Inject
    private PrivateCustomFieldValueService privateCustomFieldValueService;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    @Transactional(readOnly=true)
    @PostAuthorize(value="hasPermission(returnObject , 'READ') or hasRole('ROLE_ADMIN')")
    public CampaignFolder getOne(Long campaignFolderId) {
        return (CampaignFolder)this.dao.getOne(campaignFolderId);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<CampaignFolder> findAllReadable(Pageable pageable) {
        List projects = this.projectFinder.findAllReadable();
        Collection ids = CollectionUtils.collect((Collection)projects, (Transformer)new IdCollector());
        if (ids.isEmpty()) {
            return new PageImpl(Collections.emptyList(), pageable, 0L);
        }
        return this.dao.findAllInProjects(ids, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#folderId,'org.squashtest.tm.domain.campaign.CampaignFolder' , 'READ')")
    public Page<CampaignLibraryNode> findFolderContent(long folderId, Pageable pageable) {
        return this.dao.findFolderContent(folderId, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#folderId,'org.squashtest.tm.domain.campaign.CampaignFolder' , 'READ')")
    public Page<CampaignLibraryNode> findFolderAllContent(long folderId, Pageable pageable) {
        return this.dao.findFolderAllContent(folderId, pageable);
    }

    @Override
    public CampaignFolder addCampaignFolder(CampaignFolderDto folderDto) throws InvocationTargetException, IllegalAccessException {
        CampaignFolder folder = new CampaignFolder();
        folder.setName(folderDto.getName());
        folder.setDescription(folderDto.getDescription());
        this.addToParent(folderDto, folder);
        if (folderDto.getCustomFields() != null) {
            List<CustomFieldValueDto> listCufsDto = folderDto.getCustomFields();
            this.customFieldValueHelper.patchCustomFieldValue((BoundEntity)folder, listCufsDto);
        }
        this.entityManager.persist((Object)folder);
        this.entityManager.flush();
        return folder;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.campaign.CampaignFolder' , 'WRITE')")
    public CampaignFolder patchCampaignFolder(CampaignFolderDto folderPatch, long id) {
        CampaignFolder folder = this.getOne(id);
        folder.setName(folderPatch.getName());
        folder.setDescription(folderPatch.getDescription());
        if (folderPatch.getCustomFields() != null) {
            List<CustomFieldValueDto> listCufsDto = folderPatch.getCustomFields();
            this.customFieldValueHelper.patchCustomFieldValue((BoundEntity)folder, listCufsDto);
        }
        return folder;
    }

    @Override
    public void deleteFolder(List<Long> folderIds) {
        this.campaignLibraryNavigationService.deleteNodes(folderIds);
    }

    private void addToParent(CampaignFolderDto folderDto, CampaignFolder folder) {
        ParentEntity parent = folderDto.getParent();
        switch (parent.getRestType()) {
            case PROJECT: {
                this.addCampaignFolderToLibrary(folder, folderDto, parent);
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.addCampaignFolderToFolder(folder, folderDto, parent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Programmatic error : Rest type " + (Object)((Object)parent.getRestType()) + "is not a valid parent. You should validate this before.");
            }
        }
    }

    private void addCampaignFolderToFolder(CampaignFolder folder, CampaignFolderDto folderDto, ParentEntity parent) {
        CampaignFolder campaignFolder = (CampaignFolder)this.entityManager.find(CampaignFolder.class, (Object)parent.getId());
        if (campaignFolder == null) {
            throw new IllegalArgumentException("Programmatic error : test case folder with id " + parent.getId() + "is unknown. You should validate this before.");
        }
        this.campaignLibraryNavigationService.addFolderToFolder(campaignFolder.getId().longValue(), (Folder)folder);
    }

    private void addCampaignFolderToLibrary(CampaignFolder folder, CampaignFolderDto folderDto, ParentEntity parent) {
        Project project = (Project)this.entityManager.find(Project.class, (Object)parent.getId());
        if (project == null) {
            throw new IllegalArgumentException("Programmatic error : project with id " + parent.getId() + "is unknown. You should validate this before.");
        }
        this.campaignLibraryNavigationService.addFolderToLibrary(project.getCampaignLibrary().getId().longValue(), (Folder)folder);
    }
}

