/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.WrappedDtoWithCustomFields;
import org.squashtest.tm.plugin.rest.jackson.model.WrappedDtoWithDenormalizedFields;
import org.squashtest.tm.plugin.rest.service.RestInternalCustomFieldValueUpdaterService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.denormalizedfield.DenormalizedFieldValueManager;

@Service
@Transactional
class InternalCustomFieldValueUpdaterServiceImpl
implements RestInternalCustomFieldValueUpdaterService {
    @Inject
    private CustomFieldValueFinderService cufService;
    @Inject
    private DenormalizedFieldValueManager denoService;

    InternalCustomFieldValueUpdaterServiceImpl() {
    }

    @Override
    public void mergeCustomFields(WrappedDtoWithCustomFields<?> wrappedDto) {
        this.mergeCustomFields((BoundEntity)wrappedDto.getWrapped(), wrappedDto.getCustomFields());
    }

    @Override
    public void mergeCustomFields(BoundEntity entity, List<CustomFieldValueDto> dtos) {
        if (dtos == null || dtos.isEmpty()) {
            return;
        }
        List currentValues = this.cufService.findAllCustomFieldValues(entity);
        for (CustomFieldValueDto dto : dtos) {
            String code = dto.getCode();
            RawValue value = dto.getValue();
            CustomFieldValue targetValue = this.locateActualValue(currentValues, code);
            if (targetValue == null || value == null) continue;
            value.setValueFor(targetValue);
        }
    }

    @Override
    public void mergeDenormalizedFields(WrappedDtoWithDenormalizedFields wrappedDto) {
        DenormalizedFieldHolder wrapped = wrappedDto.getWrapped();
        List<CustomFieldValueDto> dtos = wrappedDto.getDenormalizedFields();
        this.mergeDenormalizedFields(wrapped, dtos);
    }

    @Override
    public void mergeDenormalizedFields(DenormalizedFieldHolder entity, List<CustomFieldValueDto> dtos) {
        if (dtos == null || dtos.isEmpty()) {
            return;
        }
        List currentValues = this.denoService.findAllForEntity(entity);
        for (CustomFieldValueDto dto : dtos) {
            String code = dto.getCode();
            RawValue value = dto.getValue();
            DenormalizedFieldValue targetValue = this.locateDenormalizedValue(currentValues, code);
            if (targetValue == null || value == null) continue;
            value.setValueFor(targetValue);
        }
    }

    private CustomFieldValue locateActualValue(List<CustomFieldValue> currentValues, String code) {
        for (CustomFieldValue cfv : currentValues) {
            if (!cfv.getCustomField().getCode().equals(code)) continue;
            return cfv;
        }
        return null;
    }

    private DenormalizedFieldValue locateDenormalizedValue(List<DenormalizedFieldValue> currentValues, String code) {
        for (DenormalizedFieldValue dfv : currentValues) {
            if (!dfv.getCode().equals(code)) continue;
            return dfv;
        }
        return null;
    }
}

