/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.databind.util.StdConverter;
import javax.inject.Inject;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.Resource;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.plugin.rest.jackson.model.UnauthorizedResource;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Component
public class UnauthorizedResourcesConverter
extends StdConverter<Resource<? extends Identified>, Resource<?>> {
    @Inject
    private PermissionEvaluationService permService;
    @Inject
    private RelProvider relProvider;

    public Resource<?> convert(Resource<? extends Identified> value) {
        if (this.permService.canRead(value.getContent())) {
            return value;
        }
        return this.createUnauthorized(value);
    }

    private <T extends Identified> Resource<UnauthorizedResource> createUnauthorized(Resource<T> resource) {
        Identified entity = (Identified)resource.getContent();
        String entityType = this.relProvider.getItemResourceRelFor(entity.getClass());
        UnauthorizedResource unauthRes = new UnauthorizedResource(entityType, entity.getId());
        return new Resource((Object)unauthRes, (Iterable)resource.getLinks());
    }
}

