/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import java.io.IOException;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.domain.tf.automationrequest.RemoteAutomationRequestExtender;

public class TestCaseAutomationStatusPropertyWriter
extends VirtualBeanPropertyWriter {
    private static final String AUTOMATION_STATUS_PROPERTY_LABEL = "automation_status";

    public TestCaseAutomationStatusPropertyWriter() {
    }

    private TestCaseAutomationStatusPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType) {
        super(propDef, contextAnnotations, declaredType);
    }

    protected Object value(Object bean, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        TestCase testCaseHolder = (TestCase)bean;
        Project project = testCaseHolder.getProject();
        if (TestCaseAutomatable.Y.equals((Object)testCaseHolder.getAutomatable()) && project.isAllowAutomationWorkflow()) {
            AutomationRequest automRequest = testCaseHolder.getAutomationRequest();
            if (AutomationWorkflowType.NATIVE.equals((Object)project.getAutomationWorkflowType())) {
                return automRequest.getRequestStatus();
            }
            RemoteAutomationRequestExtender rare = automRequest.getRemoteAutomationRequestExtender();
            return rare != null ? rare.getRemoteRequestStatus() : this.writePropertyIfNull(jsonGenerator);
        }
        return null;
    }

    private Object writePropertyIfNull(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeNullField(AUTOMATION_STATUS_PROPERTY_LABEL);
        return null;
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new TestCaseAutomationStatusPropertyWriter(propDef, declaringClass.getAnnotations(), type);
    }
}

