/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.library.WhichNodeVisitor;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.service.internal.library.PathService;

@Component
public class PathPropertyWriter
extends VirtualBeanPropertyWriter {
    @Inject
    private PathService pathService;

    public PathPropertyWriter() {
    }

    public PathPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, PathService service) {
        super(propDef, contextAnnotations, declaredType);
        this.pathService = service;
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        String path;
        if (!TreeNode.class.isAssignableFrom(bean.getClass())) {
            throw new IllegalArgumentException("attempted to serializer the path of a '" + bean.getClass().getName() + "', but only implementors of TreeNode are accepted");
        }
        EntityType beanType = new WhichNodeVisitor().getTypeOf((TreeNode)bean);
        switch (beanType) {
            case TEST_CASE_FOLDER: 
            case TEST_CASE: {
                path = this.pathService.buildTestCasePath(((TestCaseLibraryNode)bean).getId().longValue());
                break;
            }
            case REQUIREMENT_FOLDER: 
            case REQUIREMENT: {
                path = this.pathService.buildRequirementPath(((RequirementLibraryNode)bean).getId().longValue());
                break;
            }
            case CAMPAIGN_FOLDER: 
            case CAMPAIGN: {
                path = this.pathService.buildCampaignPath(((CampaignLibraryNode)bean).getId().longValue());
                break;
            }
            default: {
                path = "not-implemented";
            }
        }
        return path;
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new PathPropertyWriter(propDef, declaringClass.getAnnotations(), type, this.pathService);
    }
}

