/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.library.WhichNodeVisitor;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.plugin.rest.core.service.NodeHierarchyHelpService;
import org.squashtest.tm.plugin.rest.core.web.BasicResourceAssembler;

@Component
public class ParentNodePropertyWriter
extends VirtualBeanPropertyWriter {
    @Inject
    private NodeHierarchyHelpService service;
    @Inject
    private BasicResourceAssembler assembler;

    public ParentNodePropertyWriter() {
    }

    public ParentNodePropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, NodeHierarchyHelpService service, BasicResourceAssembler assembler) {
        super(propDef, contextAnnotations, declaredType);
        this.service = service;
        this.assembler = assembler;
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        Object container;
        EntityType beanType = new WhichNodeVisitor().getTypeOf((TreeNode)bean);
        switch (beanType) {
            case TEST_CASE_FOLDER: 
            case TEST_CASE: {
                container = this.service.findParentFor((TestCaseLibraryNode)bean);
                break;
            }
            case REQUIREMENT_FOLDER: 
            case REQUIREMENT: {
                container = this.service.findParentFor((RequirementLibraryNode)bean);
                break;
            }
            case CAMPAIGN_FOLDER: 
            case CAMPAIGN: {
                container = this.service.findParentFor((CampaignLibraryNode)bean);
                break;
            }
            case ITERATION: {
                Iteration iteration = (Iteration)bean;
                container = iteration.getCampaign();
                break;
            }
            case TEST_SUITE: {
                TestSuite testSuite = (TestSuite)bean;
                container = testSuite.getIteration();
                break;
            }
            default: {
                container = null;
            }
        }
        Object containerBean = Library.class.isAssignableFrom(container.getClass()) ? ((Library)container).getProject() : container;
        return this.assembler.toResource((Identified)containerBean);
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new ParentNodePropertyWriter(propDef, declaringClass.getAnnotations(), type, this.service, this.assembler);
    }
}

