/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collection;
import javax.inject.Inject;
import org.springframework.hateoas.Resource;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.plugin.rest.core.web.BasicResourceAssembler;

@Component
public class CollectionHateoasWrapperSerializer<T extends Identified>
extends StdSerializer<Collection<T>> {
    @Inject
    private BasicResourceAssembler resAssembler;

    public CollectionHateoasWrapperSerializer() {
        super(TypeFactory.defaultInstance().constructType(Collection.class));
    }

    public void serialize(Collection<T> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartArray();
        JsonSerializer valSerializer = provider.findValueSerializer(Resource.class);
        for (Identified v : value) {
            Resource res = this.resAssembler.toResource(v);
            valSerializer.serialize((Object)res, gen, provider);
        }
        gen.writeEndArray();
    }
}

