/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.plugin.rest.jackson.model.ActionTestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.CalledTestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.KeywordTestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDtoVisitor;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="_type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ActionTestStepDto.class, name="action-step"), @JsonSubTypes.Type(value=CalledTestStepDto.class, name="call-step"), @JsonSubTypes.Type(value=KeywordTestStepDto.class, name="keyword-step")})
public abstract class TestStepDto {
    private Long id;
    @JsonProperty(value="test_case")
    private TestCaseDto testCaseDto;
    @JsonIgnore
    private Long projectId;
    @JsonProperty(value="index")
    private Integer index;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TestCaseDto getTestCaseDto() {
        return this.testCaseDto;
    }

    public void setTestCaseDto(TestCaseDto testCaseDto) {
        this.testCaseDto = testCaseDto;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public abstract void accept(TestStepDtoVisitor var1);

    public static TestStep convertDto(TestStepDto dto) {
        final TestStep[] testSteps = new TestStep[1];
        TestStepDtoVisitor visitor = new TestStepDtoVisitor(){

            @Override
            public void visit(ActionTestStepDto actionTestStepDto) {
                ActionTestStep actionTestStep = new ActionTestStep();
                actionTestStep.setAction(actionTestStepDto.getAction());
                actionTestStep.setExpectedResult(actionTestStepDto.getExpectedResult());
                testSteps[0] = actionTestStep;
            }

            @Override
            public void visit(CalledTestStepDto calledTestStepDto) {
                CallTestStep callTestStep = new CallTestStep();
                callTestStep.setCalledTestCase(calledTestStepDto.getCalledTestCase());
                callTestStep.setCalledDataset(calledTestStepDto.getCalledDataset());
                callTestStep.setDelegateParameterValues(calledTestStepDto.isDelegateParameterValues());
                testSteps[0] = callTestStep;
            }

            @Override
            public void visit(KeywordTestStepDto keywordTestStepDto) {
                KeywordTestStep keywordTestStep = new KeywordTestStep();
                keywordTestStep.setKeyword(keywordTestStepDto.getKeyword());
                testSteps[0] = keywordTestStep;
            }
        };
        dto.accept(visitor);
        return testSteps[0];
    }
}

