/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Set;
import org.springframework.context.i18n.LocaleContextHolder;
import org.squashtest.tm.core.foundation.lang.Wrapped;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.library.Copiable;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.plugin.rest.jackson.deserializer.RestNatureTypeCategoryDeserializer;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetDto;
import org.squashtest.tm.plugin.rest.jackson.model.KeywordTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.ParentEntity;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementVersionDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestNode;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.ScriptedTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDto;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="_type")
@JsonTypeName(value="test-case")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ScriptedTestCaseDto.class, name="scripted-test-case"), @JsonSubTypes.Type(value=KeywordTestCaseDto.class, name="keyword-test-case")})
public class TestCaseDto
implements RestNode {
    private Long id;
    private Project project;
    private String name;
    private String description;
    private String reference;
    private String prerequisite;
    private List<TestStepDto> steps;
    private Set<RequirementVersionCoverage> requirementVersionCoverages;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY, value="verified_requirements")
    private Set<RequirementVersionDto> verifiedRequirements;
    private Set<Parameter> parameters;
    private Set<DatasetDto> datasets;
    private TestCaseImportance importance;
    @JsonDeserialize(using=RestNatureTypeCategoryDeserializer.class)
    private InfoListItem nature;
    @JsonDeserialize(using=RestNatureTypeCategoryDeserializer.class)
    private InfoListItem type;
    private TestCaseStatus status;
    private TestCaseExecutionMode executionMode;
    private Boolean importanceAuto;
    private TestCaseAutomatable automatable;
    @JsonProperty(value="automated_test")
    private AutomatedTest automatedTest;
    @JsonProperty(value="automation_status")
    private AutomationRequestStatus automationStatus;
    @JsonProperty(value="automation_priority")
    private Integer automationPriority;
    private Set<Milestone> milestones;
    @JsonProperty(value="custom_fields")
    private List<CustomFieldValueDto> customFields;
    private ParentEntity parent;
    private String path;
    @JsonProperty(value="automated_test_technology")
    private String automatedTestTechnology;
    @JsonProperty(value="automated_test_reference")
    private String automatedTestReference;
    @JsonProperty(value="scm_repository")
    private String scmRepository;

    public static TestCase convertDto(TestCaseDto testCaseDto) {
        final Wrapped testCaseWrapped = new Wrapped();
        TestCaseDtoVisitor dtoVisitor = new TestCaseDtoVisitor(){

            @Override
            public void visit(TestCaseDto testCaseDto) {
                testCaseWrapped.setValue((Object)new TestCase());
            }

            @Override
            public void visit(ScriptedTestCaseDto scriptedTestCaseDto) {
                ScriptedTestCase scriptedTestCase = new ScriptedTestCase();
                String dtoScript = scriptedTestCaseDto.getScript();
                if (dtoScript != null) {
                    scriptedTestCase.setScript(dtoScript);
                } else {
                    scriptedTestCase.populateInitialScript(LocaleContextHolder.getLocale().getLanguage());
                }
                testCaseWrapped.setValue((Object)scriptedTestCase);
            }

            @Override
            public void visit(KeywordTestCaseDto keywordTestCaseDto) {
                testCaseWrapped.setValue((Object)new KeywordTestCase());
            }
        };
        testCaseDto.accept(dtoVisitor);
        return (TestCase)testCaseWrapped.getValue();
    }

    public Set<RequirementVersionDto> getVerifiedRequirements() {
        return this.verifiedRequirements;
    }

    public void setVerifiedRequirements(Set<RequirementVersionDto> dtos) {
        this.verifiedRequirements = dtos;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPrerequisite() {
        return this.prerequisite;
    }

    public void setPrerequisite(String prerequisite) {
        this.prerequisite = prerequisite;
    }

    public List<TestStepDto> getSteps() {
        return this.steps;
    }

    public void setSteps(List<TestStepDto> steps) {
        this.steps = steps;
    }

    public Set<RequirementVersionCoverage> getRequirementVersionCoverages() {
        return this.requirementVersionCoverages;
    }

    public void setRequirementVersionCoverages(Set<RequirementVersionCoverage> requirementVersionCoverages) {
        this.requirementVersionCoverages = requirementVersionCoverages;
    }

    public Set<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Set<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Set<DatasetDto> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(Set<DatasetDto> datasets) {
        this.datasets = datasets;
    }

    public TestCaseImportance getImportance() {
        return this.importance;
    }

    public void setImportance(TestCaseImportance importance) {
        this.importance = importance;
    }

    public InfoListItem getNature() {
        return this.nature;
    }

    public void setNature(InfoListItem nature) {
        this.nature = nature;
    }

    public InfoListItem getType() {
        return this.type;
    }

    public void setType(InfoListItem type) {
        this.type = type;
    }

    public TestCaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(TestCaseStatus status) {
        this.status = status;
    }

    public TestCaseExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(TestCaseExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public Boolean getImportanceAuto() {
        return this.importanceAuto;
    }

    public void setImportanceAuto(Boolean importanceAuto) {
        this.importanceAuto = importanceAuto;
    }

    public AutomatedTest getAutomatedTest() {
        return this.automatedTest;
    }

    public void setAutomatedTest(AutomatedTest automatedTest) {
        this.automatedTest = automatedTest;
    }

    public Set<Milestone> getMilestones() {
        return this.milestones;
    }

    public void setMilestones(Set<Milestone> milestones) {
        this.milestones = milestones;
    }

    @Override
    public List<CustomFieldValueDto> getCustomFields() {
        return this.customFields;
    }

    @Override
    public RestType getRestType() {
        return RestType.TEST_CASE;
    }

    public void setCustomFields(List<CustomFieldValueDto> customFields) {
        this.customFields = customFields;
    }

    @Override
    public ParentEntity getParent() {
        return this.parent;
    }

    public void setParent(ParentEntity parent) {
        this.parent = parent;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void notifyAssociatedWithProject(Project project) {
        this.project = project;
    }

    public AttachmentList getAttachmentList() {
        throw new UnsupportedOperationException();
    }

    public Copiable createCopy() {
        throw new UnsupportedOperationException();
    }

    public void accept(NodeVisitor nodeVisitor) {
        throw new UnsupportedOperationException();
    }

    public Library<?> getLibrary() {
        return this.getProject().getTestCaseLibrary();
    }

    public void accept(TestCaseDtoVisitor testCaseDtoVisitor) {
        testCaseDtoVisitor.visit(this);
    }

    public AutomationRequestStatus getAutomationStatus() {
        return this.automationStatus;
    }

    public void setAutomationStatus(AutomationRequestStatus automationStatus) {
        this.automationStatus = automationStatus;
    }

    public Integer getAutomationPriority() {
        return this.automationPriority;
    }

    public void setAutomationPriority(Integer automationPriority) {
        this.automationPriority = automationPriority;
    }

    public TestCaseAutomatable getAutomatable() {
        return this.automatable;
    }

    public void setAutomatable(TestCaseAutomatable automatable) {
        this.automatable = automatable;
    }

    public String getAutomatedTestTechnology() {
        return this.automatedTestTechnology;
    }

    public void setAutomatedTestTechnology(String automatedTestTechnology) {
        this.automatedTestTechnology = automatedTestTechnology;
    }

    public String getAutomatedTestReference() {
        return this.automatedTestReference;
    }

    public void setAutomatedTestReference(String automatedTestReference) {
        this.automatedTestReference = automatedTestReference;
    }

    public String getScmRepository() {
        return this.scmRepository;
    }

    public void setScmRepository(String scmRepository) {
        this.scmRepository = scmRepository;
    }
}

