/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.model;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectCopyParameterDto;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectDto;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectTemplateDto;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="_type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ProjectDto.class, name="project"), @JsonSubTypes.Type(value=ProjectTemplateDto.class, name="project-template")})
public abstract class GenericProjectDto {
    private Long id;
    private String description;
    private String label;
    private String name;
    private boolean active = true;
    private GenericProjectCopyParameterDto params;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public GenericProjectCopyParameterDto getParams() {
        return this.params;
    }

    public void setParams(GenericProjectCopyParameterDto params) {
        this.params = params;
    }

    public abstract void accept(GenericProjectDtoVisitor var1);

    public static GenericProject convertDto(GenericProjectDto dto) {
        final GenericProject[] genericProjects = new GenericProject[1];
        GenericProjectDtoVisitor visitor = new GenericProjectDtoVisitor(){

            @Override
            public void visit(ProjectDto projectDto) {
                Project project = new Project();
                project.setName(projectDto.getName());
                project.setDescription(projectDto.getDescription());
                project.setLabel(projectDto.getLabel());
                genericProjects[0] = project;
            }

            @Override
            public void visit(ProjectTemplateDto projectTemplateDto) {
                ProjectTemplate projectTemplate = new ProjectTemplate();
                projectTemplate.setName(projectTemplateDto.getName());
                projectTemplate.setDescription(projectTemplateDto.getDescription());
                projectTemplate.setLabel(projectTemplateDto.getLabel());
                genericProjects[0] = projectTemplate;
            }
        };
        dto.accept(visitor);
        return genericProjects[0];
    }
}

