/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.squashtest.tm.domain.customfield.RawValue;

public class RestRawValueDeserializer
extends JsonDeserializer<RawValue> {
    public RawValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this.doDeserialize(p);
    }

    public RawValue deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.doDeserialize(p);
    }

    private RawValue doDeserialize(JsonParser p) throws IOException {
        JsonNode root = (JsonNode)p.getCodec().readTree(p);
        if (root == null) {
            return new RawValue();
        }
        if (root.isArray()) {
            ArrayList<String> values = new ArrayList<String>();
            Iterator elements = root.elements();
            while (elements.hasNext()) {
                JsonNode value = (JsonNode)elements.next();
                values.add(value.asText());
            }
            return new RawValue(values);
        }
        return new RawValue(root.asText());
    }
}

