/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Configurable;
import org.squashtest.tm.plugin.rest.jackson.deserializer.JsonCrawler;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetParamValueDto;

@Configurable
public class DatasetParamValueDtoDeserializer
extends JsonDeserializer<DatasetParamValueDto> {
    @Inject
    private JsonCrawler jsonCrawler;

    public DatasetParamValueDto deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this.doDeserialize(p);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return super.deserializeWithType(p, ctxt, typeDeserializer);
    }

    private DatasetParamValueDto doDeserialize(JsonParser p) throws IOException {
        JsonNode rootNode = (JsonNode)p.getCodec().readTree(p);
        DatasetParamValueDto datasetParamValueDto = new DatasetParamValueDto();
        datasetParamValueDto.setParameterId(this.jsonCrawler.asMandatoryLong(rootNode, "parameter_id"));
        datasetParamValueDto.setParameterName(this.jsonCrawler.asMandatoryString(rootNode, "parameter_name"));
        datasetParamValueDto.setValue(this.jsonCrawler.asMandatoryString(rootNode, "parameter_value"));
        datasetParamValueDto.setTestCaseId(this.jsonCrawler.asMandatoryLong(rootNode, "parameter_test_case_id"));
        return datasetParamValueDto;
    }
}

