/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.plugin.rest.core.exception.ProgrammingError;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationHints;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.utils.DeserializationUtils;
import org.squashtest.tm.plugin.rest.validators.helper.CustomFieldValueValidationHelper;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;

@Deprecated
@Component
public class CustomFieldValuesMergerDeserializer
extends JsonDeserializer<List<CustomFieldValue>> {
    @Inject
    private CustomFieldValueFinderService cufService;
    @Inject
    private CustomFieldBindingFinderService bindingService;

    public Class<?> handledType() {
        return List.class;
    }

    public List<CustomFieldValue> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this.deserialize(p, ctxt, new ArrayList<CustomFieldValue>());
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, ctxt, new ArrayList<CustomFieldValue>());
    }

    public List<CustomFieldValue> deserialize(JsonParser p, DeserializationContext ctxt, List<CustomFieldValue> intoValue) throws IOException, JsonProcessingException {
        if (!p.isExpectedStartArrayToken()) {
            throw new IOException("malformed json for field 'custom_fields', an array was expected");
        }
        List<CustomFieldValueDto> dtos = this.deserializeDto(p);
        DeserializationHints hints = DeserializationUtils.getHints(ctxt);
        Project project = hints.getProject();
        DeserializationHints.Mode mode = hints.getMode();
        BoundEntity entity = DeserializationUtils.findBoundEntityOrDie(p);
        List<CustomFieldValue> currentValues = null;
        switch (mode) {
            case DESERIALIZE_UPDATE: {
                currentValues = this.cufService.findAllCustomFieldValues(entity);
                break;
            }
            case DESERIALIZE_CREATE: {
                currentValues = this.createCustomFieldsFor(project.getId(), entity.getBoundEntityType());
                break;
            }
            default: {
                throw new ProgrammingError("attempted to deserialize custom fields in a mode that is neither create or update !");
            }
        }
        this.validate((BindingResult)hints.getBindingResult(), project, entity, currentValues, dtos);
        this.updateValues(currentValues, dtos);
        intoValue.clear();
        intoValue.addAll(currentValues);
        return intoValue;
    }

    private List<CustomFieldValueDto> deserializeDto(JsonParser p) {
        try {
            ArrayList<CustomFieldValueDto> dtos = new ArrayList<CustomFieldValueDto>();
            p.nextToken();
            Iterator iter = p.readValuesAs(CustomFieldValueDto.class);
            while (iter.hasNext()) {
                dtos.add((CustomFieldValueDto)iter.next());
            }
            return dtos;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void validate(BindingResult binding, Project project, BoundEntity entity, List<CustomFieldValue> currentValues, List<CustomFieldValueDto> dtos) {
        List<CustomField> customFields = CustomFieldValueValidationHelper.collectCustomFields(currentValues);
        CustomFieldValueValidationHelper helper = new CustomFieldValueValidationHelper(entity.getBoundEntityType(), project.getId(), customFields, dtos, (Errors)binding);
        helper.validate();
    }

    private void updateValues(List<CustomFieldValue> currentValues, List<CustomFieldValueDto> dtos) {
        for (CustomFieldValueDto dto : dtos) {
            Iterator<CustomFieldValue> iterator = currentValues.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                String code = dto.getCode();
                RawValue value = dto.getValue();
                CustomFieldValue targetValue = this.locateActualValue(currentValues, code);
                if (targetValue == null || value == null) continue;
                value.setValueFor(targetValue);
            }
        }
    }

    private CustomFieldValue locateActualValue(List<CustomFieldValue> currentValues, String code) {
        for (CustomFieldValue cfv : currentValues) {
            if (!cfv.getCustomField().getCode().equals(code)) continue;
            return cfv;
        }
        return null;
    }

    private List<CustomFieldValue> createCustomFieldsFor(Long projectId, BindableEntity type) {
        List bindings = this.bindingService.findCustomFieldsForProjectAndEntity(projectId.longValue(), type);
        ArrayList<CustomFieldValue> values = new ArrayList<CustomFieldValue>(bindings.size());
        for (CustomFieldBinding binding : bindings) {
            values.add(binding.createNewValue());
        }
        return values;
    }
}

