/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller.helper;

import javax.inject.Inject;
import org.springframework.hateoas.Resource;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyPermission;

@Component
public class ResourceLinksHelper {
    @Inject
    private BasePathAwareLinkBuildingService linkService;

    public void addAllLinksForPartyPermission(Long projectId, Resource<RestPartyPermission> res) {
        res.add(this.linkService.createRelationTo(GenericProject.class, projectId.longValue(), "self", "/permissions"));
    }

    public void addAllLinksForDataset(Resource<Dataset> res) {
        Dataset ds = (Dataset)res.getContent();
        res.add(this.linkService.createLinkTo((Identified)ds.getTestCase()));
    }

    public void addAllLinksForTestCaseFolder(Resource<TestCaseFolder> res) {
        TestCaseFolder cf = (TestCaseFolder)res.getContent();
        res.add(this.linkService.createLinkTo((Identified)cf.getProject()));
        res.add(this.linkService.createRelationTo((Identified)cf, "content"));
        res.add(this.linkService.createRelationTo((Identified)cf, "attachments"));
    }

    public void addAllLinksForCampaignFolder(Resource<CampaignFolder> res) {
        CampaignFolder cf = (CampaignFolder)res.getContent();
        res.add(this.linkService.createLinkTo((Identified)cf.getProject()));
        res.add(this.linkService.createRelationTo((Identified)cf, "content"));
        res.add(this.linkService.createRelationTo((Identified)cf, "attachments"));
    }

    public void addAllLinksForRequirementFolder(Resource<RequirementFolder> res) {
        RequirementFolder cf = (RequirementFolder)res.getContent();
        res.add(this.linkService.createLinkTo((Identified)cf.getProject()));
        res.add(this.linkService.createRelationTo((Identified)cf, "content"));
        res.add(this.linkService.createRelationTo((Identified)cf, "attachments"));
    }

    public void addAllLinksForExecution(Resource<Execution> res) {
        Execution exec = (Execution)res.getContent();
        if (!this.hasSelfLink(res)) {
            res.add(this.linkService.createSelfLink((Identified)exec));
        }
        res.add(this.linkService.createLinkTo((Identified)exec.getProject()));
        res.add(this.linkService.createLinkTo((Identified)exec.getTestPlan(), "test_plan_item"));
        res.add(this.linkService.createRelationTo((Identified)exec, "execution-steps"));
        res.add(this.linkService.createRelationTo((Identified)exec, "attachments"));
    }

    public void addAllLinksForTestCase(Resource<TestCase> res) {
        TestCase tc = (TestCase)res.getContent();
        res.add(this.linkService.createLinkTo((Identified)tc.getProject()));
        res.add(this.linkService.createRelationTo((Identified)tc, "steps"));
        res.add(this.linkService.createRelationTo((Identified)tc, "parameters"));
        res.add(this.linkService.createRelationTo((Identified)tc, "datasets"));
        res.add(this.linkService.createRelationTo((Identified)tc, "attachments"));
    }

    public void addAllLinksForTestSuite(Resource<TestSuite> res) {
        TestSuite ts = (TestSuite)res.getContent();
        res.add(this.linkService.createLinkTo((Identified)ts.getProject()));
        res.add(this.linkService.createLinkTo((Identified)ts.getIteration()));
        res.add(this.linkService.createRelationTo((Identified)ts, "test-plan"));
        res.add(this.linkService.createRelationTo((Identified)ts, "attachments"));
    }

    public void addAllLinksForRequirement(Resource<Requirement> res) {
        Requirement requirement = (Requirement)res.getContent();
        res.add(this.linkService.createLinkTo((Identified)requirement.getCurrentVersion().getProject()));
        res.add(this.linkService.createRelationTo((Identified)requirement.getCurrentVersion(), "current_version"));
    }

    public void populateLinks(Resource<TestStep> res) {
        TestStep step = (TestStep)res.getContent();
        res.add(this.linkService.createLinkTo((Identified)step.getTestCase()));
    }

    public void addAllLinksForIteration(Resource<Iteration> res) {
        Iteration iteration = (Iteration)res.getContent();
        res.add(this.linkService.createLinkTo((Identified)iteration.getProject()));
        res.add(this.linkService.createLinkTo((Identified)iteration.getCampaign()));
        res.add(this.linkService.createRelationTo((Identified)iteration, "test-suites"));
        res.add(this.linkService.createRelationTo((Identified)iteration, "test-plan"));
        res.add(this.linkService.createRelationTo((Identified)iteration, "attachments"));
    }

    public void addAllLinksForIterationTestPlanItem(Resource<IterationTestPlanItem> res) {
        IterationTestPlanItem itp = (IterationTestPlanItem)res.getContent();
        res.add(this.linkService.createLinkTo((Identified)itp.getProject()));
        if (itp.getReferencedTestCase() != null) {
            res.add(this.linkService.createLinkTo((Identified)itp.getReferencedTestCase()));
        }
        if (itp.getReferencedDataset() != null) {
            res.add(this.linkService.createLinkTo((Identified)itp.getReferencedDataset()));
        }
        res.add(this.linkService.createLinkTo((Identified)itp.getIteration()));
        res.add(this.linkService.createRelationTo((Identified)itp, "executions"));
    }

    public void addAllLinksForCampaignTestPlanItem(Resource<CampaignTestPlanItem> res) {
        CampaignTestPlanItem ctpi = (CampaignTestPlanItem)res.getContent();
        res.add(this.linkService.createLinkTo((Identified)ctpi.getProject()));
        if (ctpi.getReferencedTestCase() != null) {
            res.add(this.linkService.createLinkTo((Identified)ctpi.getReferencedTestCase()));
        }
        if (ctpi.getReferencedDataset() != null) {
            res.add(this.linkService.createLinkTo((Identified)ctpi.getReferencedDataset()));
        }
        res.add(this.linkService.createLinkTo((Identified)ctpi.getCampaign()));
    }

    private boolean hasSelfLink(Resource<?> res) {
        return res.getLink("self") != null;
    }
}

