/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.UserDto;
import org.squashtest.tm.plugin.rest.service.RestPartyService;
import org.squashtest.tm.plugin.rest.validators.PartyPatchValidator;
import org.squashtest.tm.plugin.rest.validators.PartyPostValidator;

@RestApiController(value=User.class)
@UseDefaultRestApiConfiguration
public class RestUserController
extends BaseRestController {
    @Inject
    private RestPartyService restPartyService;
    @Inject
    private PartyPostValidator partyPostValidator;
    @Inject
    private PartyPatchValidator partyPatchValidator;

    @RequestMapping(value={"/users/{id}"}, method={RequestMethod.GET})
    @EntityGetter
    @DynamicFilterExpression(value="*, teams[*, -members]")
    public ResponseEntity<Resource<User>> findUser(@PathVariable(value="id") long userId) {
        User user = (User)this.restPartyService.findById(userId);
        Resource res = this.toResource((Identified)user);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.GET})
    @ResponseBody
    @DynamicFilterExpression(value="login, active, group")
    public ResponseEntity<PagedResources<Resource>> findAllUsers(Pageable pageable) {
        Page<User> pagedUsers = this.restPartyService.findAllUsers(pageable);
        PagedResources res = this.toPagedResources(pagedUsers);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<User>> createUser(@RequestBody UserDto userDto) throws BindException {
        this.validatePostUser(userDto);
        User user = (User)this.restPartyService.createParty(userDto);
        Resource res = this.toResource((Identified)user);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/users/{ids}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteUsers(@PathVariable(value="ids") List<Long> userIds) {
        this.restPartyService.deleteUsers(userIds);
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(value={"/users/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*, teams[*, -members]")
    public ResponseEntity<Resource<User>> patchUser(@RequestBody UserDto patch, @PathVariable(value="id") long id) throws BindException {
        patch.setId(id);
        this.validatePatchUser(patch);
        User user = (User)this.restPartyService.patchParty(patch, id);
        Resource res = this.toResource((Identified)user);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/users/{userId}/teams"}, method={RequestMethod.GET})
    @ResponseBody
    @DynamicFilterExpression(value="*, -members")
    public ResponseEntity<PagedResources<Resource>> findTeams(@PathVariable(value="userId") long userId, Pageable pageable) {
        Page<Team> teams = this.restPartyService.findTeamsByUser(userId, pageable);
        PagedResources res = this.toPagedResources(teams);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/users/{userId}/teams"}, method={RequestMethod.POST})
    public ResponseEntity<Void> addTeamsToUser(@PathVariable(value="userId") long userId, @RequestParam(value="teamIds") List<Long> teamIds) {
        this.restPartyService.addTeamsToUser(userId, teamIds);
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(value={"/users/{userId}/teams"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> disassociateUserFromTeams(@PathVariable(value="userId") long userId, @RequestParam(value="teamIds") List<Long> teamIds) {
        this.restPartyService.disassociateUserFromTeams(userId, teamIds);
        return ResponseEntity.noContent().build();
    }

    private void validatePatchUser(UserDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, "patch-user");
        this.partyPatchValidator.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, "patch-user");
    }

    private void validatePostUser(UserDto userDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)userDto, "post-user");
        this.partyPostValidator.validate(userDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(userDto, errors, "post-user");
    }
}

