/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.TestSuiteDto;
import org.squashtest.tm.plugin.rest.service.RestTestSuiteService;
import org.squashtest.tm.plugin.rest.validators.TestSuiteValidator;

@RestApiController(value=TestSuite.class)
@UseDefaultRestApiConfiguration
public class RestTestSuiteController
extends BaseRestController {
    public static final String TEST_SUITE_DYNAMIC_FILTER = "*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status]";
    @Inject
    private RestTestSuiteService restTestSuiteService;
    @Inject
    private TestSuiteValidator testSuiteValidator;
    @Inject
    private ResourceLinksHelper linksHelper;

    @RequestMapping(value={"/test-suites/{id}"}, method={RequestMethod.GET})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status]")
    public ResponseEntity<Resource<TestSuite>> findTestSuite(@PathVariable(value="id") long id) {
        TestSuite testSuite = this.restTestSuiteService.getOne(id);
        Resource res = this.toResource((Identified)testSuite);
        this.linksHelper.addAllLinksForTestSuite((Resource<TestSuite>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-suites/{id}/test-plan"})
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case[name, reference], referenced_dataset[name], iteration[name,reference], executions[execution_status,last_executed_by,last_executed_on],-iteration")
    public ResponseEntity<PagedResources<Resource>> findIterationTestPlan(@PathVariable(value="id") long testSuiteId, Pageable pageable) {
        Page<IterationTestPlanItem> steps = this.restTestSuiteService.findTestPlan(testSuiteId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(steps, "test-plan");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-suites"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status]")
    public ResponseEntity<Resource<TestSuite>> addTestSuite(@RequestBody TestSuiteDto testSuiteDto) throws BindException {
        this.testSuiteValidator.validatePostTestSuite(testSuiteDto);
        TestSuite testSuite = this.restTestSuiteService.addTestSuite(testSuiteDto.getParent().getId(), testSuiteDto);
        Resource res = this.toResource((Identified)testSuite);
        this.linksHelper.addAllLinksForTestSuite((Resource<TestSuite>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/test-suites/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status]")
    public ResponseEntity<Resource<TestSuite>> ModifyTestSuite(@RequestBody TestSuiteDto testSuiteDto, @PathVariable(value="id") Long testSuiteId) throws BindException {
        this.testSuiteValidator.validatePatchTestSuite(testSuiteDto, testSuiteId);
        TestSuite testSuite = this.restTestSuiteService.modifyTestSuite(testSuiteDto, testSuiteId);
        Resource res = this.toResource((Identified)testSuite);
        this.linksHelper.addAllLinksForTestSuite((Resource<TestSuite>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-suites/{ids}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteTestSuite(@PathVariable(value="ids") List<Long> testSuiteIds) {
        this.restTestSuiteService.deleteTestSuite(testSuiteIds);
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(value={"/test-suites/{idTestSuite}/test-plan/{ids}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status]")
    public ResponseEntity<Resource<TestSuite>> detachItemFromTestSuite(@PathVariable(value="idTestSuite") Long idTestSuite, @PathVariable(value="ids") List<Long> ids) {
        TestSuite testSuite = this.restTestSuiteService.detachTestPlanFromTestSuite(idTestSuite, ids);
        Resource res = this.toResource((Identified)testSuite);
        this.linksHelper.addAllLinksForTestSuite((Resource<TestSuite>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-suites/{idTestSuite}/test-plan/{ids}"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status]")
    public ResponseEntity<Resource<TestSuite>> attachTestPlanToTestSuite(@PathVariable(value="idTestSuite") Long idTestSuite, @PathVariable(value="ids") List<Long> ids) {
        TestSuite testSuite = this.restTestSuiteService.attachTestPlanToTestSuite(idTestSuite, ids);
        Resource res = this.toResource((Identified)testSuite);
        this.linksHelper.addAllLinksForTestSuite((Resource<TestSuite>)res);
        return ResponseEntity.ok((Object)res);
    }
}

