/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDto;
import org.squashtest.tm.plugin.rest.service.RestTestCaseService;
import org.squashtest.tm.plugin.rest.service.RestTestStepService;
import org.squashtest.tm.plugin.rest.validators.TestStepPatchValidator;
import org.squashtest.tm.plugin.rest.validators.TestStepPostValidator;

@RestApiController(value=TestStep.class)
@UseDefaultRestApiConfiguration
public class RestTestStepController
extends BaseRestController {
    @Inject
    private RestTestStepService restTestStepService;
    @Inject
    private RestTestCaseService restTestCaseService;
    @Inject
    private TestStepPostValidator testStepPostValidator;
    @Inject
    private TestStepPatchValidator testStepPatchValidator;
    @Inject
    private ResourceLinksHelper linksHelper;

    @RequestMapping(value={"/test-steps/{id}"})
    @EntityGetter(value={ActionTestStep.class, CallTestStep.class, KeywordTestStep.class})
    @DynamicFilterExpression(value="*, test_case[name] ,called_test_case[name], called_dataset[name]")
    public ResponseEntity<Resource<TestStep>> findTestStep(@PathVariable(value="id") long id) {
        TestStep step = this.restTestStepService.getOne(id);
        Resource res = this.toResource((Identified)step);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-cases/{testCaseId}/steps"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*, test_case[name], called_test_case[name], called_dataset[name]")
    public ResponseEntity<Resource<TestStep>> createTestStep(@RequestBody TestStepDto testStepDto, @PathVariable(value="testCaseId") long testCaseId) throws BindException, InvocationTargetException, IllegalAccessException {
        TestCase testCase = this.restTestCaseService.getOne(testCaseId);
        testStepDto.setProjectId(testCase.getProject().getId());
        this.validatePostTestStep(testStepDto);
        TestStep ats = this.restTestStepService.createTestStep(testStepDto, testCase);
        Resource res = this.toResource((Identified)ats);
        this.linksHelper.populateLinks((Resource<TestStep>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/test-steps/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*, test_case[name], called_test_case[name], called_dataset[name]")
    public ResponseEntity<Resource<TestStep>> patchTestStep(@RequestBody TestStepDto patch, @PathVariable(value="id") long id) throws BindException, InvocationTargetException, IllegalAccessException {
        TestStep testStep = this.restTestStepService.getOne(id);
        patch.setId(id);
        patch.setProjectId(testStep.getTestCase().getProject().getId());
        this.validatePatchTestStep(patch);
        testStep = this.restTestStepService.patchTestStep(patch, id);
        Resource res = this.toResource((Identified)testStep);
        this.linksHelper.populateLinks((Resource<TestStep>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-steps/{ids}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteTestStep(@PathVariable(value="ids") List<Long> ids) {
        this.restTestStepService.deleteTestStepsByIds(ids);
        return ResponseEntity.noContent().build();
    }

    private void validatePatchTestStep(TestStepDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, "patch-test-step");
        this.testStepPatchValidator.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, "patch-test-step");
    }

    private void validatePostTestStep(TestStepDto testStepDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)testStepDto, "post-test-step");
        this.testStepPostValidator.validate(testStepDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(testStepDto, errors, "post-test-step");
    }
}

