/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.ContentInclusion;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseFolderDto;
import org.squashtest.tm.plugin.rest.service.RestTestCaseFolderService;
import org.squashtest.tm.plugin.rest.validators.TestCaseFolderPatchValidator;
import org.squashtest.tm.plugin.rest.validators.TestCaseFolderPostValidator;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;

@RestApiController(value=TestCaseFolder.class)
@UseDefaultRestApiConfiguration
public class RestTestCaseFolderController
extends BaseRestController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTestCaseFolderController.class);
    @Inject
    private RestTestCaseFolderService service;
    @Inject
    private TestCaseFolderPostValidator testCaseFolderPostValidator;
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private TestCaseFolderPatchValidator testCaseFolderPatchValidator;
    private TestCaseLibraryNavigationService testCaseLibraryNavigationService;

    @RequestMapping(value={"/test-case-folders"})
    @ResponseBody
    @DynamicFilterExpression(value="name")
    public ResponseEntity<PagedResources<Resource>> findAllReadableTestCaseFolders(Pageable pageable) {
        Page<TestCaseFolder> folders = this.service.findAllReadable(pageable);
        PagedResources res = this.toPagedResources(folders);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-case-folders/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<Resource<TestCaseFolder>> findTestCaseFolder(@PathVariable(value="id") long id) {
        TestCaseFolder folder = this.service.getOne(id);
        Resource res = this.toResource((Identified)folder);
        res.add(this.createLinkTo((Identified)folder.getProject()));
        res.add(this.createRelationTo("content"));
        res.add(this.createRelationTo("attachments"));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-case-folders/{id}/content"})
    @ResponseBody
    @DynamicFilterExpression(value="name,reference")
    public ResponseEntity<PagedResources<Resource>> findTestCaseFolderContent(@PathVariable(value="id") long folderId, Pageable pageable, ContentInclusion include) {
        Page<TestCaseLibraryNode> content = null;
        switch (include) {
            case NESTED: {
                content = this.service.findFolderAllContent(folderId, pageable);
                break;
            }
            default: {
                content = this.service.findFolderContent(folderId, pageable);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(content, "content");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-case-folders"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<Resource<TestCaseFolder>> createCampaignFolder(@RequestBody TestCaseFolderDto folderDto) throws BindException, InvocationTargetException, IllegalAccessException {
        this.testCaseFolderPostValidator.validatePostTestCaseFolder(folderDto);
        TestCaseFolder folder = this.service.addTestCaseFolder(folderDto);
        Resource res = this.toResource((Identified)folder);
        this.linksHelper.addAllLinksForTestCaseFolder((Resource<TestCaseFolder>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/test-case-folders/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<Resource<TestCaseFolder>> patchTestCaseFolder(@RequestBody TestCaseFolderDto folderPatch, @PathVariable(value="id") long id) throws BindException {
        folderPatch.setId(id);
        this.testCaseFolderPatchValidator.validatePatchTestCaseFolder(folderPatch);
        TestCaseFolder folder = this.service.patchTestCaseFolder(folderPatch, id);
        Resource res = this.toResource((Identified)folder);
        this.linksHelper.addAllLinksForTestCaseFolder((Resource<TestCaseFolder>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-case-folders/{ids}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Void> deleteTestCaseFolder(@PathVariable(value="ids") List<Long> folderIds) {
        this.service.deleteFolder(folderIds);
        return ResponseEntity.noContent().build();
    }
}

