/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.DisableSort;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.TestCaseTypeFilter;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDto;
import org.squashtest.tm.plugin.rest.service.RestDatasetService;
import org.squashtest.tm.plugin.rest.service.RestParameterService;
import org.squashtest.tm.plugin.rest.service.RestTestCaseService;
import org.squashtest.tm.plugin.rest.validators.ParameterValidator;
import org.squashtest.tm.plugin.rest.validators.TestCasePatchValidator;
import org.squashtest.tm.plugin.rest.validators.TestCasePostValidator;
import org.squashtest.tm.plugin.rest.validators.TestStepValidator;

@RestApiController(value=TestCase.class)
@UseDefaultRestApiConfiguration
public class RestTestCaseController
extends BaseRestController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTestCaseController.class);
    private static final String POST_TEST_CASE = "post-test-case";
    private static final String PATCH_TEST_CASE = "patch-test-case";
    @Inject
    private RestTestCaseService restTestCaseService;
    @Inject
    private RestParameterService restParameterService;
    @Inject
    private RestDatasetService restDatasetService;
    @Inject
    private TestCasePostValidator testCasePostValidator;
    @Inject
    private TestCasePatchValidator testCasePatchValidator;
    @Inject
    private ParameterValidator parameterValidator;
    @Inject
    private TestStepValidator testStepValidator;
    @Inject
    private ResourceLinksHelper linksHelper;

    @RequestMapping(value={"/test-cases"})
    @ResponseBody
    @DynamicFilterExpression(value="name,reference")
    public ResponseEntity<PagedResources<Resource>> getAllReadableTestCases(Pageable pageable, TestCaseTypeFilter type) {
        Page<TestCase> tcs = null;
        switch (type) {
            case STANDARD: {
                tcs = this.restTestCaseService.getAllStandardTestCases(pageable);
                break;
            }
            case SCRIPTED: {
                tcs = this.restTestCaseService.getAllScriptedTestCases(pageable);
                break;
            }
            case KEYWORD: {
                tcs = this.restTestCaseService.getAllKeywordTestCases(pageable);
                break;
            }
            default: {
                tcs = this.restTestCaseService.getAllReadableTestCases(pageable);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(tcs, "test-cases");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-cases/{id}"}, method={RequestMethod.GET})
    @EntityGetter(value={TestCase.class, ScriptedTestCase.class, KeywordTestCase.class})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name],  verified_requirements[name], parameters[name], datasets[name], automated_test[name],steps[*, called_test_case[name], called_dataset[name], -test_case], attachments[name]")
    public ResponseEntity<Resource<TestCase>> findTestCase(@PathVariable(value="id") long id) {
        TestCase tc = this.restTestCaseService.getOne(id);
        Resource res = this.toResource((Identified)tc);
        this.linksHelper.addAllLinksForTestCase((Resource<TestCase>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-cases/{id}/steps"})
    @ResponseBody
    @DynamicFilterExpression(value="*, called_test_case[name], -test_case ")
    public ResponseEntity<PagedResources<Resource>> findTestCaseSteps(@PathVariable(value="id") long tcid, @DisableSort Pageable pageable) {
        Page<TestStep> steps = this.restTestCaseService.getTestCaseSteps(tcid, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(steps, "steps");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-cases/{id}/parameters"})
    @ResponseBody
    @DynamicFilterExpression(value="*, test_case[name]")
    public ResponseEntity<PagedResources<Resource>> findTestCaseParameters(@PathVariable(value="id") long id, Pageable pageable) {
        Page<Parameter> parameters = this.restParameterService.findAllByTestCaseId(id, pageable);
        PagedResources res = this.toPagedResources(parameters);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-cases/{id}/datasets"})
    @ResponseBody
    @DynamicFilterExpression(value="*,parameters[name],-test_case")
    public ResponseEntity<PagedResources<Resource>> findTestCaseDatasets(@PathVariable(value="id") long id, Pageable pageable) {
        Page<Dataset> datasets = this.restDatasetService.findAllByTestCaseId(id, pageable);
        PagedResources res = this.toPagedResources(datasets);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-cases"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name], verified_requirements[name], parameters[name], steps[*, called_test_case[name], -test_case ]")
    public ResponseEntity<Resource<TestCase>> createTestCase(@RequestBody TestCaseDto testCaseDto) throws BindException, InvocationTargetException, IllegalAccessException {
        this.validatePostTestCase(testCaseDto);
        TestCase tc = this.restTestCaseService.createTestCase(testCaseDto);
        Resource res = this.toResource((Identified)tc);
        this.linksHelper.addAllLinksForTestCase((Resource<TestCase>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/test-cases/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name], verified_requirements[name], parameters[name], steps[*, called_test_case[name], -test_case ]")
    public ResponseEntity<Resource<TestCase>> patchTestCase(@RequestBody TestCaseDto patch, @PathVariable(value="id") long id) throws BindException {
        patch.setId(id);
        this.validatePatchTestCase(patch);
        TestCase tc = this.restTestCaseService.patchTestCase(patch, id);
        Resource res = this.toResource((Identified)tc);
        this.linksHelper.addAllLinksForTestCase((Resource<TestCase>)res);
        return ResponseEntity.ok((Object)res);
    }

    @ResponseBody
    @RequestMapping(value={"/test-cases/{ids}"}, method={RequestMethod.DELETE})
    public ResponseEntity<List<String>> deleteTestCase(@PathVariable(value="ids") List<Long> testCaseIds, @RequestParam(name="dry-run", required=false) Boolean dryRun, Locale locale) {
        List<String> reportMessages = this.restTestCaseService.deleteTestCase(testCaseIds, dryRun, locale);
        return ResponseEntity.ok(reportMessages);
    }

    private void validatePostTestCase(TestCaseDto testCaseDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)testCaseDto, POST_TEST_CASE);
        this.testCasePostValidator.validate(testCaseDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        this.validateParameters(testCaseDto, errors);
        this.validateTestSteps(testCaseDto, errors);
        ErrorHandlerHelper.throwIfError(testCaseDto, errors, POST_TEST_CASE);
    }

    private void validatePatchTestCase(TestCaseDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, PATCH_TEST_CASE);
        this.testCasePatchValidator.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, PATCH_TEST_CASE);
    }

    private void validateParameters(TestCaseDto testCaseDto, List<Errors> errors) {
        Set<Parameter> parameters = testCaseDto.getParameters();
        if (parameters == null) {
            return;
        }
        for (Parameter parameter : parameters) {
            BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)testCaseDto, POST_TEST_CASE);
            this.parameterValidator.validate(parameter, (Errors)validation);
            if (!validation.hasErrors()) continue;
            errors.add((Errors)validation);
        }
    }

    private void validateTestSteps(TestCaseDto testCaseDto, List<Errors> errors) {
        List<TestStepDto> stepDtos = testCaseDto.getSteps();
        if (stepDtos == null) {
            return;
        }
        for (TestStepDto stepDto : stepDtos) {
            stepDto.setProjectId(testCaseDto.getProject().getId());
            BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)testCaseDto, POST_TEST_CASE);
            this.testStepValidator.validate(stepDto, (Errors)validation);
            if (!validation.hasErrors()) continue;
            errors.add((Errors)validation);
        }
    }
}

