/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.service.RestTestAutomationServerService;

@RestApiController(value=TestAutomationServer.class)
@UseDefaultRestApiConfiguration
public class RestTestAutomationServerController
extends BaseRestController {
    @Inject
    private RestTestAutomationServerService serverService;

    @RequestMapping(value={"/test-automation-servers/{id}"}, method={RequestMethod.GET})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<TestAutomationServer>> findTestAutomationServer(@PathVariable(value="id") long serverId) {
        TestAutomationServer server = this.serverService.getOne(serverId);
        Resource res = this.toResource((Identified)server);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/test-automation-servers"}, method={RequestMethod.GET})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<PagedResources<Resource>> findAllReadableTestAutomationServer(Pageable pageable) {
        Page<TestAutomationServer> tcs = this.serverService.findAllReadable(pageable);
        PagedResources res = this.toPagedResources(tcs);
        return ResponseEntity.ok((Object)res);
    }
}

