/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.TeamDto;
import org.squashtest.tm.plugin.rest.service.RestPartyService;
import org.squashtest.tm.plugin.rest.validators.PartyPatchValidator;
import org.squashtest.tm.plugin.rest.validators.PartyPostValidator;

@RestApiController(value=Team.class)
@UseDefaultRestApiConfiguration
public class RestTeamController
extends BaseRestController {
    @Inject
    private RestPartyService restPartyService;
    @Inject
    private PartyPostValidator partyPostValidator;
    @Inject
    private PartyPatchValidator partyPatchValidator;

    @RequestMapping(value={"/teams/{id}"}, method={RequestMethod.GET})
    @EntityGetter
    @DynamicFilterExpression(value="*, members[*, -teams]")
    public ResponseEntity<Resource<Team>> findTeam(@PathVariable(value="id") long teamId) {
        Team team = (Team)this.restPartyService.findById(teamId);
        Resource res = this.toResource((Identified)team);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/teams"}, method={RequestMethod.GET})
    @ResponseBody
    @DynamicFilterExpression(value="name")
    public ResponseEntity<PagedResources<Resource>> findAllTeams(Pageable pageable) {
        Page<Team> pagedTeams = this.restPartyService.findAllTeams(pageable);
        PagedResources res = this.toPagedResources(pagedTeams);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/teams"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<Team>> createTeam(@RequestBody TeamDto teamDto) throws BindException {
        this.validatePostTeam(teamDto);
        Team team = (Team)this.restPartyService.createParty(teamDto);
        Resource res = this.toResource((Identified)team);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/teams/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*, members[*, -teams]")
    public ResponseEntity<Resource<Team>> patchTeam(@RequestBody TeamDto patch, @PathVariable(value="id") long id) throws BindException {
        patch.setId(id);
        this.validatePatchTeam(patch);
        Team team = (Team)this.restPartyService.patchParty(patch, id);
        Resource res = this.toResource((Identified)team);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/teams/{ids}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteTeams(@PathVariable(value="ids") List<Long> teamIds) {
        this.restPartyService.deleteTeams(teamIds);
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(value={"/teams/{teamId}/members"}, method={RequestMethod.GET})
    @ResponseBody
    @DynamicFilterExpression(value="*, -teams")
    public ResponseEntity<PagedResources<Resource>> findTeamMembers(@PathVariable(value="teamId") long teamId, Pageable pageable) {
        Page<User> users = this.restPartyService.findAllTeamMembers(teamId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(users, "members");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/teams/{teamId}/members"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Void> addMembersToTeam(@PathVariable(value="teamId") long teamId, @RequestParam(value="userIds") List<Long> userIds) {
        this.restPartyService.addMembersToTeam(teamId, userIds);
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(value={"/teams/{teamId}/members"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Void> removeMembersFromTeam(@PathVariable(value="teamId") long teamId, @RequestParam(value="userIds") List<Long> userIds) {
        this.restPartyService.removeMembersFromTeam(teamId, userIds);
        return ResponseEntity.noContent().build();
    }

    private void validatePostTeam(TeamDto teamDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)teamDto, "post-team");
        this.partyPostValidator.validate(teamDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(teamDto, errors, "post-team");
    }

    private void validatePatchTeam(TeamDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, "patch-team");
        this.partyPatchValidator.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, "patch-team");
    }
}

