/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import javax.inject.Inject;
import org.springframework.hateoas.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.service.RestRequirementVersionService;

@RestApiController(value=RequirementVersion.class)
@UseDefaultRestApiConfiguration
public class RestRequirementVersionController
extends BaseRestController {
    @Inject
    private RestRequirementVersionService service;

    @RequestMapping(value={"/requirement-versions/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, requirement[name], verifying_test_cases[name]")
    @EntityGetter
    public ResponseEntity<Resource<RequirementVersion>> findRequirementVersion(@PathVariable(value="id") long id) {
        RequirementVersion ver = this.service.findRequirementVersion(id);
        Resource res = this.toResource((Identified)ver);
        res.add(this.linkService.createLinkTo((Identified)ver.getProject()));
        res.add(this.linkService.createLinkTo((Identified)ver.getRequirement()));
        res.add(this.linkService.createRelationTo((Identified)ver, "attachments"));
        return ResponseEntity.ok((Object)res);
    }
}

