/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.ContentInclusion;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementFolderDto;
import org.squashtest.tm.plugin.rest.service.RestRequirementFolderService;
import org.squashtest.tm.plugin.rest.validators.RequirementFolderPatchValidator;
import org.squashtest.tm.plugin.rest.validators.RequirementFolderPostValidator;

@RestApiController(value=RequirementFolder.class)
@UseDefaultRestApiConfiguration
public class RestRequirementFolderController
extends BaseRestController {
    @Inject
    private RestRequirementFolderService service;
    @Inject
    private RequirementFolderPostValidator requirementFolderPostValidator;
    @Inject
    private RequirementFolderPatchValidator requirementFolderPatchValidator;
    @Inject
    private ResourceLinksHelper linksHelper;

    @RequestMapping(value={"/requirement-folders"})
    @ResponseBody
    @DynamicFilterExpression(value="name")
    public ResponseEntity<PagedResources<Resource>> findAllReadableRequirementFolders(Pageable pageable) {
        Page<RequirementFolder> folders = this.service.findAllReadable(pageable);
        PagedResources res = this.toPagedResources(folders);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/requirement-folders/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    @EntityGetter
    public ResponseEntity<Resource<RequirementFolder>> findRequirementFolder(@PathVariable(value="id") long id) {
        RequirementFolder folder = this.service.getOne(id);
        Resource res = this.toResource((Identified)folder);
        res.add(this.linkService.createLinkTo((Identified)folder.getProject()));
        res.add(this.createRelationTo("content"));
        res.add(this.createRelationTo("attachments"));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/requirement-folders/{id}/content"})
    @ResponseBody
    @DynamicFilterExpression(value="name")
    public ResponseEntity<PagedResources<Resource>> findTestCaseFolderContent(@PathVariable(value="id") long folderId, Pageable pageable, ContentInclusion include) {
        Page<RequirementLibraryNode<?>> content = null;
        switch (include) {
            case NESTED: {
                content = this.service.findFolderAllContent(folderId, pageable);
                break;
            }
            default: {
                content = this.service.findFolderContent(folderId, pageable);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(content, "content");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/requirement-folders"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<Resource<RequirementFolder>> createRequirementFolder(@RequestBody RequirementFolderDto folderDto) throws BindException, InvocationTargetException, IllegalAccessException {
        this.requirementFolderPostValidator.validatePostRequirementFolder(folderDto);
        RequirementFolder folder = this.service.addRequirementFolder(folderDto);
        Resource res = this.toResource((Identified)folder);
        this.linksHelper.addAllLinksForRequirementFolder((Resource<RequirementFolder>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/requirement-folders/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<Resource<RequirementFolder>> patchRequirementFolder(@RequestBody RequirementFolderDto folderPatch, @PathVariable(value="id") long id) throws BindException {
        folderPatch.setId(id);
        this.requirementFolderPatchValidator.validatePatchRequirementFolder(folderPatch);
        RequirementFolder folder = this.service.patchRequirementFolder(folderPatch, id);
        Resource res = this.toResource((Identified)folder);
        this.linksHelper.addAllLinksForRequirementFolder((Resource<RequirementFolder>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/requirement-folders/{ids}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Void> deleteTestCaseFolder(@PathVariable(value="ids") List<Long> folderIds) {
        this.service.deleteFolder(folderIds);
        return ResponseEntity.noContent().build();
    }
}

