/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.ContentInclusion;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementDto;
import org.squashtest.tm.plugin.rest.service.RestRequirementVersionService;
import org.squashtest.tm.plugin.rest.service.RestVerifyingTestCaseManagerService;
import org.squashtest.tm.plugin.rest.validators.RequirementValidator;
import org.squashtest.tm.plugin.rest.validators.RequirementVersionValidator;

@RestApiController(value=Requirement.class)
@UseDefaultRestApiConfiguration
public class RestRequirementController
extends BaseRestController {
    @Inject
    private RestRequirementVersionService service;
    @Inject
    private RestVerifyingTestCaseManagerService verifyingTestCaseManager;
    @Inject
    private RequirementValidator requirementValidator;
    @Inject
    private RequirementVersionValidator requirementVersionValidator;
    @Inject
    private ResourceLinksHelper linksHelper;

    @RequestMapping(value={"/requirements"}, method={RequestMethod.GET}, params={"!remote_key", "!server_name"})
    @ResponseBody
    @DynamicFilterExpression(value="name, current_version[reference]")
    public ResponseEntity<PagedResources<Resource>> findAllReadable(Pageable pageable) {
        Page<Requirement> reqs = this.service.findAllReadable(pageable);
        PagedResources res = this.toPagedResources(reqs);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/requirements"}, method={RequestMethod.GET}, params={"remote_key", "server_name"})
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name], current_version[*, -requirement, verifying_test_cases[name]], versions[name,version_number]")
    public ResponseEntity<PagedResources<Resource>> findSynchronizedRequirement(@RequestParam(value="remote_key") String remoteKey, @RequestParam(value="server_name") String serverName, Pageable pageable) {
        List<Requirement> reqs = this.service.findSynchronizedRequirementsBy(remoteKey, serverName);
        PageImpl pagedReqs = new PageImpl(reqs, pageable, (long)reqs.size());
        PagedResources res = this.toPagedResources((Page)pagedReqs);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/requirements/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name], current_version[*, -requirement, verifying_test_cases[name]], versions[name,version_number]")
    @EntityGetter
    public ResponseEntity<Resource<Requirement>> findRequirement(@PathVariable(value="id") long id) {
        Requirement req = this.service.findRequirement(id);
        Resource res = this.toResource((Identified)req);
        res.add(this.linkService.createLinkTo((Identified)req.getProject()));
        res.add(this.linkService.createLinkTo((Identified)req.getCurrentVersion(), "current_version"));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/requirements/{id}/children"})
    @ResponseBody
    @DynamicFilterExpression(value="name, current_version[reference]")
    public ResponseEntity<PagedResources<Resource>> findAllReadable(@PathVariable(value="id") long requirementId, Pageable pageable, ContentInclusion include) {
        Page<Requirement> content = null;
        switch (include) {
            case NESTED: {
                content = this.service.findRequirementAllChildren(requirementId, pageable);
                break;
            }
            default: {
                content = this.service.findRequirementChildren(requirementId, pageable);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(content, "children");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/requirements"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name], current_version[*, -requirement, verifying_test_cases[name]], versions[name,version_number]")
    public ResponseEntity<Resource<Requirement>> createRequirement(@RequestBody RequirementDto requirementDto) throws BindException {
        this.requirementValidator.validatePostRequirement(requirementDto);
        this.requirementVersionValidator.validateRequirementVersion(requirementDto.getCurrentVersion());
        Requirement req = this.service.createRequirement(requirementDto);
        Resource res = this.toResource((Identified)req);
        res.add(this.linkService.createLinkTo((Identified)req.getProject()));
        res.add(this.linkService.createLinkTo((Identified)req.getCurrentVersion(), "current_version"));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/requirements/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name], current_version[*, -requirement, verifying_test_cases[name]], versions[name,version_number]")
    public ResponseEntity<Resource<Requirement>> ModifyRequirement(@RequestBody RequirementDto requirementDto, @PathVariable(value="id") Long requirementId) throws BindException {
        this.requirementValidator.validatePatchRequirement(requirementDto, requirementId);
        this.requirementVersionValidator.validatePatchRequirementVersion(requirementDto.getCurrentVersion(), requirementId);
        Requirement requirement = this.service.modifyRequirement(requirementDto, requirementId);
        Resource res = this.toResource((Identified)requirement);
        this.linksHelper.addAllLinksForRequirement((Resource<Requirement>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/requirements/{ids}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteRequirements(@PathVariable(value="ids") List<Long> reqIds) {
        this.service.deleteRequirements(reqIds);
        return ResponseEntity.noContent().build();
    }

    @ResponseBody
    @RequestMapping(value={"/requirements/{id}/coverages"}, method={RequestMethod.POST})
    @DynamicFilterExpression(value="*, project[name], parent[name], current_version[*, -requirement, verifying_test_cases[name]], versions[name, version__number]")
    public ResponseEntity<Resource<Requirement>> associateTestCases(@PathVariable(value="id") Long requirementId, @RequestParam(value="testCaseIds") List<Long> testCaseIds) throws BindException {
        this.requirementValidator.validateAssociateTestCases(requirementId, testCaseIds);
        Requirement requirement = this.service.findRequirement(requirementId);
        RequirementVersion requirementVersion = requirement.getCurrentVersion();
        this.verifyingTestCaseManager.addVerifyingTestCasesToRequirementVersion(testCaseIds, requirementVersion.getId());
        Resource res = this.toResource((Identified)requirement);
        res.add(this.linkService.createLinkTo((Identified)requirement.getProject()));
        res.add(this.linkService.createLinkTo((Identified)requirement.getCurrentVersion(), "current_version"));
        return ResponseEntity.ok((Object)res);
    }
}

