/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import com.google.common.base.CaseFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.ContentInclusion;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyPermission;
import org.squashtest.tm.plugin.rest.service.RestPartyService;
import org.squashtest.tm.plugin.rest.service.RestProjectService;
import org.squashtest.tm.plugin.rest.validators.GenericProjectPostValidator;
import org.squashtest.tm.security.acls.PermissionGroup;

@RestApiController(value=GenericProject.class)
@UseDefaultRestApiConfiguration
public class RestProjectController
extends BaseRestController {
    @Inject
    private RestProjectService service;
    @Inject
    private RestPartyService partyService;
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private GenericProjectPostValidator genericProjectPostValidator;

    @RequestMapping(value={"/projects/{id}"})
    @EntityGetter(value={Project.class, ProjectTemplate.class})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<GenericProject>> findProject(@PathVariable(value="id") long projectId) {
        GenericProject project = this.service.getOne(projectId);
        Resource res = this.toResource((Identified)project);
        res.add(this.linkService.fromBasePath(ControllerLinkBuilder.linkTo(((RestProjectController)((Object)ControllerLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findRequirementLibraryContent(projectId, null, null))).withRel("requirements"));
        res.add(this.linkService.fromBasePath(ControllerLinkBuilder.linkTo(((RestProjectController)((Object)ControllerLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findTestCaseLibraryContent(projectId, null, null))).withRel("test-cases"));
        res.add(this.linkService.fromBasePath(ControllerLinkBuilder.linkTo(((RestProjectController)((Object)ControllerLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findCampaignLibraryContent(projectId, null, null))).withRel("campaigns"));
        res.add(this.linkService.fromBasePath(ControllerLinkBuilder.linkTo(((RestProjectController)((Object)ControllerLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findPartyPermissionsByProject(projectId))).withRel("permissions"));
        res.add(this.createRelationTo("attachments"));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/projects"}, params={"projectName"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<GenericProject>> findProjectByName(@RequestParam(value="projectName") String projectName) {
        GenericProject project = this.service.getOneByName(projectName);
        Resource res = this.toResource((Identified)project);
        long projectId = project.getId();
        res.add(this.linkService.fromBasePath(ControllerLinkBuilder.linkTo(((RestProjectController)((Object)ControllerLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findRequirementLibraryContent(projectId, null, null))).withRel("requirements"));
        res.add(this.linkService.fromBasePath(ControllerLinkBuilder.linkTo(((RestProjectController)((Object)ControllerLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findTestCaseLibraryContent(projectId, null, null))).withRel("test-cases"));
        res.add(this.linkService.fromBasePath(ControllerLinkBuilder.linkTo(((RestProjectController)((Object)ControllerLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findCampaignLibraryContent(projectId, null, null))).withRel("campaigns"));
        res.add(this.linkService.fromBasePath(ControllerLinkBuilder.linkTo(((RestProjectController)((Object)ControllerLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findPartyPermissionsByProject(projectId))).withRel("permissions"));
        res.add(this.createRelationTo("attachments"));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/projects"})
    @ResponseBody
    @DynamicFilterExpression(value="name")
    public ResponseEntity<PagedResources<Resource>> findAllReadableProjects(Pageable pageable) {
        Page<GenericProject> projects = this.service.findAllReadable(pageable);
        PagedResources res = this.toPagedResources(projects);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/projects"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<GenericProject>> createGenericProject(@RequestBody GenericProjectDto genericProjectDto) throws BindException, InvocationTargetException, IllegalAccessException {
        this.validatePostGenericProject(genericProjectDto);
        GenericProject genericProject = this.service.createGenericProject(genericProjectDto);
        Resource res = this.toResource((Identified)genericProject);
        res.add(this.linkService.fromBasePath(ControllerLinkBuilder.linkTo(((RestProjectController)((Object)ControllerLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findRequirementLibraryContent(genericProject.getId(), null, null))).withRel("requirements"));
        res.add(this.linkService.fromBasePath(ControllerLinkBuilder.linkTo(((RestProjectController)((Object)ControllerLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findTestCaseLibraryContent(genericProject.getId(), null, null))).withRel("test-cases"));
        res.add(this.linkService.fromBasePath(ControllerLinkBuilder.linkTo(((RestProjectController)((Object)ControllerLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findCampaignLibraryContent(genericProject.getId(), null, null))).withRel("campaigns"));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/projects/{id}/requirements-library/content"})
    @DynamicFilterExpression(value="name, reference")
    public ResponseEntity<PagedResources<Resource>> findRequirementLibraryContent(@PathVariable(value="id") long projectId, Pageable paging, ContentInclusion include) {
        Page<RequirementLibraryNode> nodes = null;
        switch (include) {
            case NESTED: {
                nodes = this.service.findRequirementLibraryAllContent(projectId, paging);
                break;
            }
            default: {
                nodes = this.service.findRequirementLibraryRootContent(projectId, paging);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(nodes, "requirement-library-content");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/projects/{id}/requirements"})
    @DynamicFilterExpression(value="name, reference")
    public ResponseEntity<PagedResources<Resource>> findRequirementsByProject(@PathVariable(value="id") long projectId, Pageable paging) {
        Page<Requirement> reqs = this.service.findRequirementsByProject(projectId, paging);
        PagedResources res = this.toPagedResources(reqs);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/projects/{id}/test-cases-library/content"})
    @DynamicFilterExpression(value="name, reference")
    public ResponseEntity<PagedResources<Resource>> findTestCaseLibraryContent(@PathVariable(value="id") long projectId, Pageable paging, ContentInclusion include) {
        Page<TestCaseLibraryNode> nodes = null;
        switch (include) {
            case NESTED: {
                nodes = this.service.findTestCaseLibraryAllContent(projectId, paging);
                break;
            }
            default: {
                nodes = this.service.findTestCaseLibraryRootContent(projectId, paging);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(nodes, "test-case-library-content");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/projects/{id}/test-cases"})
    @DynamicFilterExpression(value="name, reference")
    public ResponseEntity<PagedResources<Resource>> findTestCasesByProject(@PathVariable(value="id") long projectId, Pageable paging) {
        Page<TestCase> testCases = this.service.findTestCasesByProject(projectId, paging);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(testCases, "test-cases");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/projects/{id}/campaigns-library/content"})
    @DynamicFilterExpression(value="name, reference")
    public ResponseEntity<PagedResources<Resource>> findCampaignLibraryContent(@PathVariable(value="id") long projectId, Pageable paging, ContentInclusion include) {
        Page<CampaignLibraryNode> nodes = null;
        switch (include) {
            case NESTED: {
                nodes = this.service.findCampaignLibraryAllContent(projectId, paging);
                break;
            }
            default: {
                nodes = this.service.findCampaignLibraryRootContent(projectId, paging);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(nodes, "campaign-library-content");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/projects/{id}/campaigns"})
    @DynamicFilterExpression(value="name, reference")
    public ResponseEntity<PagedResources<Resource>> findCampaignsByProject(@PathVariable(value="id") long projectId, Pageable paging) {
        Page<Campaign> testCases = this.service.findCampaignsByProject(projectId, paging);
        PagedResources res = this.toPagedResources(testCases);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/projects/{id}/permissions"})
    @DynamicFilterExpression(value="login, name")
    public ResponseEntity<Resource<RestPartyPermission>> findPartyPermissionsByProject(@PathVariable(value="id") long projectId) {
        RestPartyPermission partyPermissions = this.service.findAllPermissionsByProjectId(projectId);
        Resource res = new Resource((Object)partyPermissions, new Link[0]);
        this.linksHelper.addAllLinksForPartyPermission(projectId, (Resource<RestPartyPermission>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/projects/{projectId}/permissions/{permissionGroup}"}, method={RequestMethod.POST})
    @DynamicFilterExpression(value="login, name")
    public ResponseEntity<Resource<RestPartyPermission>> postNewPermissionToProjectWithPartyIds(@PathVariable(value="projectId") long projectId, @PathVariable(value="permissionGroup") String permissionGroup, @RequestParam(value="ids") List<Long> partyIds) throws BindException {
        PostProjectPermissionModel bean = new PostProjectPermissionModel(partyIds, permissionGroup);
        this.validatePostNewPermissionsToProject(bean);
        for (Long partyId : bean.partyIds) {
            this.service.addNewPermissionToProject(partyId, projectId, bean.permissionGroup);
        }
        RestPartyPermission partyPermissions = this.service.buildPartyPermissionDataModel(permissionGroup, partyIds);
        Resource res = new Resource((Object)partyPermissions, new Link[0]);
        this.linksHelper.addAllLinksForPartyPermission(projectId, (Resource<RestPartyPermission>)res);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/projects/{projectId}/users/{partyIds}"})
    public ResponseEntity<Void> removePartyFromProject(@PathVariable(value="projectId") long projectId, @PathVariable(value="partyIds") List<Long> partyIds) throws BindException {
        RemoveProjectPartyModel bean = new RemoveProjectPartyModel(partyIds);
        this.validateRemovePartyFromProject(bean);
        for (Long partyId : bean.partyIds) {
            this.service.deletePartyFromProject(partyId, projectId);
        }
        return ResponseEntity.noContent().build();
    }

    private void validateRemovePartyFromProject(RemoveProjectPartyModel bean) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        List partyIds = bean.partyIds;
        int i = 0;
        while (i < partyIds.size()) {
            Long partyId = (Long)partyIds.get(i);
            Party party = this.partyService.findById(partyId);
            if (party == null) {
                String fieldName = "partyIds[" + i + "]";
                String message = "No id of user or team known for " + partyId;
                BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)bean, "remove-project-party");
                validation.rejectValue(fieldName, "invalid ids for user or team", message);
                errors.add((Errors)validation);
            }
            ++i;
        }
        ErrorHandlerHelper.throwIfError(bean, errors, "remove-project-party");
    }

    private void validatePostGenericProject(GenericProjectDto genericProjectDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)genericProjectDto, "post-generic-project");
        this.genericProjectPostValidator.validate(genericProjectDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(genericProjectDto, errors, "post-generic-project");
    }

    private void validatePostNewPermissionsToProject(PostProjectPermissionModel bean) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)bean, "post-project-permission");
        int index = 0;
        for (Long partyId : bean.partyIds) {
            Party party = this.partyService.getOne(partyId);
            if (party == null) {
                String message = String.format("No id of user or team known for %d", partyId);
                String fieldName = String.format("partyIds[%d]", index);
                validation.rejectValue(fieldName, "invalid ids for user or team", message);
                errors.add((Errors)validation);
                validation = new BeanPropertyBindingResult((Object)bean, "post-project-permission");
            }
            ++index;
        }
        String rawData = bean.permissionGroup;
        if (bean.permissionGroup.equals("advanced_tester")) {
            bean.permissionGroup = "advance_tester";
        }
        bean.permissionGroup = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, bean.permissionGroup);
        if (!this.getAllPermissionGroups().contains(bean.permissionGroup)) {
            String message = String.format("No permission group known for %s", rawData);
            validation.rejectValue("permissionGroup", "invalid permission group", message);
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(bean, errors, "post-project-permission");
    }

    private List<String> getAllPermissionGroups() {
        List<PermissionGroup> groups = this.service.findAllPossiblePermission();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (PermissionGroup group : groups) {
            groupNames.add(group.getSimpleName());
        }
        return groupNames;
    }

    private class PostProjectPermissionModel {
        private List<Long> partyIds;
        private String permissionGroup;

        private PostProjectPermissionModel(List<Long> partyIds, String permissionGroup) {
            this.partyIds = partyIds;
            this.permissionGroup = permissionGroup;
        }

        public List<Long> getPartyIds() {
            return this.partyIds;
        }

        public String getPermissionGroup() {
            return this.permissionGroup;
        }
    }

    private class RemoveProjectPartyModel {
        private List<Long> partyIds;

        public RemoveProjectPartyModel(List<Long> partyIds) {
            this.partyIds = partyIds;
        }

        public List<Long> getPartyIds() {
            return this.partyIds;
        }
    }
}

