/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import javax.inject.Inject;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.ParameterDto;
import org.squashtest.tm.plugin.rest.service.RestParameterService;
import org.squashtest.tm.plugin.rest.validators.ParameterValidator;

@RestApiController(value=Parameter.class)
@UseDefaultRestApiConfiguration
public class RestParameterController
extends BaseRestController {
    @Inject
    private RestParameterService restParameterService;
    @Inject
    private ParameterValidator parameterValidator;

    @RequestMapping(value={"/parameters/{id}"})
    @EntityGetter
    @DynamicFilterExpression(value="*,name,test_case[name]")
    public ResponseEntity<Resource<Parameter>> findParameter(@PathVariable(value="id") long id) {
        Parameter p = this.restParameterService.getOne(id);
        Resource res = new Resource((Object)p, new Link[0]);
        res.add(this.createSelfLink((Identified)p));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/parameters"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*,name,test_case[name]")
    public ResponseEntity<Resource<Parameter>> postParameter(@RequestBody ParameterDto parameterDto) throws BindException {
        this.parameterValidator.validatePostParameter(parameterDto);
        Parameter parameter = this.restParameterService.addParameter(parameterDto);
        Resource res = this.toResource((Identified)parameter);
        res.add(this.createSelfLink((Identified)parameter));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/parameters/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*,name,test_case[name]")
    public ResponseEntity<Resource<Parameter>> ModifyParameter(@RequestBody ParameterDto parameterDto, @PathVariable(value="id") Long parameterId) throws BindException {
        this.parameterValidator.validatePatchParameter(parameterDto, parameterId);
        Parameter parameter = this.restParameterService.modifyParameter(parameterDto);
        Resource res = this.toResource((Identified)parameter);
        res.add(this.createSelfLink((Identified)parameter));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/parameters/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteParameter(@PathVariable(value="id") Long parameterId) {
        this.restParameterService.deleteParameter(parameterId);
        return ResponseEntity.noContent().build();
    }
}

