/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.IterationTestPlanItemDto;
import org.squashtest.tm.plugin.rest.service.RestIterationTestPlanItemService;
import org.squashtest.tm.plugin.rest.validators.IterationTestPlanItemPostValidator;

@RestApiController(value=IterationTestPlanItem.class)
@UseDefaultRestApiConfiguration
public class RestIterationTestPlanItemController
extends BaseRestController {
    public static final String ITPI_DYNAMIC_FILTER = "*, referenced_test_case[name, reference], referenced_dataset[name], iteration[name,reference], executions[execution_status,last_executed_by,last_executed_on]";
    @Inject
    private RestIterationTestPlanItemService service;
    @Inject
    private IterationTestPlanItemPostValidator iterationTestPlanItemValidator;
    @Inject
    private IterationTestPlanItemPostValidator iterationTestPlanItemPostValidator;
    @Inject
    private ResourceLinksHelper linksHelper;

    @RequestMapping(value={"/iteration-test-plan-items/{id}"}, method={RequestMethod.GET})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case[name, reference], referenced_dataset[name], iteration[name,reference], executions[execution_status,last_executed_by,last_executed_on]")
    public ResponseEntity<Resource<IterationTestPlanItem>> findIterationTestPlanItem(@PathVariable(value="id") long id) {
        IterationTestPlanItem itpi = this.service.getOne(id);
        Resource res = this.toResource((Identified)itpi);
        this.linksHelper.addAllLinksForIterationTestPlanItem((Resource<IterationTestPlanItem>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/iteration-test-plan-items/{id}/executions"}, method={RequestMethod.GET})
    @ResponseBody
    @DynamicFilterExpression(value="name, execution_order, execution_status, last_executed_by, last_executed_on")
    public ResponseEntity<PagedResources<Resource>> findItpiExecutions(@PathVariable(value="id") long itpiId, Pageable pageable) {
        Page<Execution> execs = this.service.findExecutions(itpiId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(execs, "executions");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/iteration-test-plan-items/{id}/executions"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*,execution_steps[execution_status,action,expected_result], nature[code], type[code], automated_execution_extender[result_url, result_status], -test_plan_item")
    public ResponseEntity<Resource<Execution>> createNewExecution(@PathVariable(value="id") long itpiId) {
        Execution exec = this.service.createExecution(itpiId);
        Resource res = this.toResource((Identified)exec);
        this.linksHelper.addAllLinksForExecution((Resource<Execution>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/iteration-test-plan-items"}, method={RequestMethod.GET}, params={"remote_key", "server_name"})
    @ResponseBody
    @DynamicFilterExpression(value="id")
    public ResponseEntity<PagedResources<Resource>> findItemsByCoveredRemoteRequirement(@RequestParam(value="remote_key") String remoteKey, @RequestParam(value="server_name") String serverName, Pageable pageable) {
        Page<IterationTestPlanItem> items = this.service.findItemsByCoveredRemoteRequirement(pageable, remoteKey, serverName);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(items, "iteration-test-plan-items");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/iteration-test-plan-items/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case[name, reference], referenced_dataset[name], iteration[name,reference], executions[execution_status,last_executed_by,last_executed_on]")
    public ResponseEntity<Resource<IterationTestPlanItem>> modifyTestPlanItemToCampaign(@RequestBody IterationTestPlanItemDto itpiDto, @PathVariable(value="id") long testPlanId) throws BindException {
        this.iterationTestPlanItemValidator.validatePatchTestPlanItem(itpiDto, testPlanId);
        IterationTestPlanItem itpi = this.service.modifyIterationTestPlan(itpiDto, testPlanId);
        Resource res = this.toResource((Identified)itpi);
        this.linksHelper.addAllLinksForIterationTestPlanItem((Resource<IterationTestPlanItem>)res);
        return ResponseEntity.ok((Object)res);
    }

    @ResponseBody
    @RequestMapping(value={"/iteration-test-plan-items/{testPlanItemsIds}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> removeTestPlanItemsFromIteration(@PathVariable(value="testPlanItemsIds") List<Long> testPlanItemsIds) {
        this.service.deleteIterationTestPlan(testPlanItemsIds);
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(value={"/iterations/{iterationId}/test-plan"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*,iteration-test-plan-item, referenced_test_case, referenced_dataset ")
    public ResponseEntity<Resource<IterationTestPlanItem>> addTestCasesToIteration(@RequestBody IterationTestPlanItemDto testPlanItemDto, @PathVariable(value="iterationId") long iterationId) throws BindException {
        this.iterationTestPlanItemPostValidator.validatePostTestPlanItem(testPlanItemDto, iterationId);
        IterationTestPlanItem itp = this.service.addIterationTestPlanItem(testPlanItemDto, iterationId);
        Resource res = this.toResource((Identified)itp);
        this.linksHelper.addAllLinksForIterationTestPlanItem((Resource<IterationTestPlanItem>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }
}

