/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.IterationDto;
import org.squashtest.tm.plugin.rest.service.RestCampaignService;
import org.squashtest.tm.plugin.rest.service.RestIterationService;
import org.squashtest.tm.plugin.rest.validators.IterationPatchValidator;
import org.squashtest.tm.plugin.rest.validators.IterationPostValidator;
import org.squashtest.tm.plugin.rest.validators.IterationTestPlanItemPostValidator;

@RestApiController(value=Iteration.class)
@UseDefaultRestApiConfiguration
public class RestIterationController
extends BaseRestController {
    public static final String ITERATION_DYNAMIC_FILTER = "*, parent[name], -test_plan, test_suites[name],-path";
    public static final String ITPI_EMBEDDED_FILTER = "*, referenced_test_case[name, reference], referenced_dataset[name], iteration[name,reference], executions[execution_status,last_executed_by,last_executed_on],-iteration";
    public static final String TEST_SUITE_EMBEDDED_FILTER = "*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status],-iteration";
    @Inject
    private RestIterationService restIterationService;
    @Inject
    private RestCampaignService restCampaignService;
    @Inject
    private IterationTestPlanItemPostValidator iterationTestPlanItemPostValidator;
    @Inject
    private IterationPostValidator iterationPostValidator;
    @Inject
    private IterationPatchValidator iterationPatchValidator;
    @Inject
    private ResourceLinksHelper linksHelper;

    @GetMapping(value={"/iterations/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -test_plan, test_suites[name],-path")
    public ResponseEntity<Resource<Iteration>> findIteration(@PathVariable(value="id") long id) {
        Iteration iteration = this.restIterationService.getOne(id);
        Resource res = this.toResource((Identified)iteration);
        res.add(this.linkService.createLinkTo((Identified)iteration.getProject()));
        res.add(this.linkService.createLinkTo((Identified)iteration.getCampaign()));
        res.add(this.createRelationTo("test-suites"));
        res.add(this.createRelationTo("test-plan"));
        res.add(this.createRelationTo("attachments"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/iterations"}, params={"iterationName"})
    @DynamicFilterExpression(value="*, parent[name], -test_plan, test_suites[name],-path")
    public ResponseEntity<Resource<Iteration>> findIterationByName(@RequestParam(value="iterationName") String iterationName) {
        Iteration iteration = this.restIterationService.getOneByName(iterationName);
        Resource res = this.toResource((Identified)iteration);
        res.add(this.linkService.createLinkTo((Identified)iteration.getProject()));
        res.add(this.linkService.createLinkTo((Identified)iteration.getCampaign()));
        long iterationId = iteration.getId();
        res.add(this.createRelationTo(String.valueOf(iterationId) + "/test-suites").withRel("test-suites"));
        res.add(this.createRelationTo(String.valueOf(iterationId) + "/test-plan").withRel("test-plan"));
        res.add(this.createRelationTo(String.valueOf(iterationId) + "/attachments").withRel("attachments"));
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/campaigns/{id}/iterations"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -test_plan, test_suites[name],-path")
    public ResponseEntity<Resource<Iteration>> createIteration(@RequestBody IterationDto iterationDto, @PathVariable(value="id") long campaignId) throws BindException {
        Campaign campaign = this.restCampaignService.getOne(campaignId);
        iterationDto.setProjectId(campaign.getProject().getId());
        this.validatePostIteration(iterationDto);
        Iteration iteration = this.restIterationService.createIteration(iterationDto, campaignId);
        Resource res = this.toResource((Identified)iteration);
        this.linksHelper.addAllLinksForIteration((Resource<Iteration>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/iterations/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -test_plan, test_suites[name],-path")
    public ResponseEntity<Resource<Iteration>> patchIteration(@RequestBody IterationDto patch, @PathVariable(value="id") long id) throws BindException {
        Iteration iteration = this.restIterationService.getOne(id);
        patch.setId(id);
        patch.setProjectId(iteration.getProject().getId());
        this.validatePatchIteration(patch);
        iteration = this.restIterationService.patchIteration(patch, id);
        Resource res = this.toResource((Identified)iteration);
        this.linksHelper.addAllLinksForIteration((Resource<Iteration>)res);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/iterations/{ids}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -test_plan, test_suites[name],-path")
    public ResponseEntity<Resource<Iteration>> deleteIterations(@PathVariable(value="ids") List<Long> ids) throws BindException {
        this.restIterationService.deleteIterationsByIds(ids);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/iterations/{id}/test-plan"})
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case[name, reference], referenced_dataset[name], iteration[name,reference], executions[execution_status,last_executed_by,last_executed_on],-iteration")
    public ResponseEntity<PagedResources<Resource>> findIterationTestPlan(@PathVariable(value="id") long iterationId, Pageable pageable) {
        Page<IterationTestPlanItem> steps = this.restIterationService.findIterationTestPlan(iterationId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(steps, "test-plan");
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/iterations/{id}/test-suites"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status],-iteration")
    public ResponseEntity<PagedResources<Resource>> findIterationTestSuite(@PathVariable(value="id") long iterationId, Pageable pageable) {
        Page<TestSuite> steps = this.restIterationService.findIterationTestSuite(iterationId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(steps, "test-suites");
        return ResponseEntity.ok((Object)res);
    }

    private void validatePostIteration(IterationDto iterationDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)iterationDto, "post-iteration");
        this.iterationPostValidator.validate(iterationDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(iterationDto, errors, "post-iteration");
    }

    private void validatePatchIteration(IterationDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, "patch-iteration");
        this.iterationPatchValidator.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, "patch-iteration");
    }
}

