/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import javax.inject.Inject;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.service.RestIssueService;

@RestApiController(value=Issue.class)
@UseDefaultRestApiConfiguration
public class RestIssueController
extends BaseRestController {
    @Inject
    private RestIssueService restIssueService;

    @RequestMapping(value={"/issues/{id}"}, method={RequestMethod.GET})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<Issue>> findCampaign(@PathVariable(value="id") long id) {
        throw new UnsupportedOperationException("This service is not available yet.");
    }

    @RequestMapping(value={"/executions/{idExecution}/issues"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<Issue>> attachIssueToExecution(@PathVariable(value="idExecution") long idExecution, @RequestBody IssueDto issueDto) throws UnsupportedOperationException {
        Issue issue = this.restIssueService.attachIssue(issueDto, idExecution);
        Resource res = this.toResource((Identified)issue);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }
}

