/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import javax.inject.Inject;
import org.springframework.hateoas.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationFilterExpression;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.PersistentEntity;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.ExecutionStepAndCustomFields;
import org.squashtest.tm.plugin.rest.service.RestExecutionStepService;
import org.squashtest.tm.plugin.rest.validators.CustomFieldValueHintedValidator;
import org.squashtest.tm.plugin.rest.validators.DenormalizedFieldValueHintedValidator;

@RestApiController(value=ExecutionStep.class)
@UseDefaultRestApiConfiguration
public class RestExecutionStepController
extends BaseRestController {
    public static final String PATCH_DYNAMIC_FILTER = "*, execution[execution_status]";
    @Inject
    private RestExecutionStepService restExecutionStepService;
    @Inject
    private CustomFieldValueHintedValidator cufValidator;
    @Inject
    private DenormalizedFieldValueHintedValidator denoValidator;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.cufValidator});
        binder.addValidators(new Validator[]{this.denoValidator});
    }

    @RequestMapping(value={"/execution-steps/{id}"}, method={RequestMethod.GET})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, execution[execution_status]")
    public ResponseEntity<Resource<ExecutionStep>> findExecutionStep(@PathVariable(value="id") long id) {
        ExecutionStep executionStep = this.restExecutionStepService.getOne(id);
        Resource res = this.toResource((Identified)executionStep);
        res.add(this.linkService.createLinkTo((Identified)executionStep.getProject()));
        res.add(this.linkService.createLinkTo((Identified)executionStep.getExecution()));
        res.add(this.linkService.createRelationTo((Identified)executionStep, "attachments"));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/execution-steps/{id}/execution-status/{status}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*, execution[execution_status]")
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.execution.ExecutionStep' , 'WRITE')")
    public ResponseEntity<Resource<ExecutionStep>> modifyExecutionStatus(@PathVariable(value="id") long id, @PathVariable(value="status") String status) {
        try {
            ExecutionStatus validatedStatus = ExecutionStatus.valueOf((String)status.toUpperCase());
            this.restExecutionStepService.modifyExecutionStatus(id, validatedStatus);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EnumConstantNotPresentException(ExecutionStatus.class, "Execution status " + status + " does not exist");
        }
        ExecutionStep executionStep = this.restExecutionStepService.getOne(id);
        Resource res = this.toResource((Identified)executionStep);
        res.add(this.linkService.createLinkTo((Identified)executionStep.getProject()));
        res.add(this.linkService.createLinkTo((Identified)executionStep.getExecution()));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/execution-steps/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*, execution[execution_status]")
    @DeserializationFilterExpression(value="comment")
    public ResponseEntity<Resource<ExecutionStep>> patchExecutionStep(@Validated @PersistentEntity ExecutionStepAndCustomFields step) {
        this.restExecutionStepService.updateStep(step);
        ExecutionStep unwrapped = (ExecutionStep)step.getWrapped();
        Resource res = this.toResource((Identified)unwrapped);
        res.add(this.linkService.createLinkTo((Identified)unwrapped.getProject()));
        res.add(this.linkService.createLinkTo((Identified)unwrapped.getExecution()));
        return ResponseEntity.ok((Object)res);
    }
}

