/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.KeywordExecution;
import org.squashtest.tm.domain.execution.ScriptedExecution;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationFilterExpression;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.PersistentEntity;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.ExecutionAndCustomFields;
import org.squashtest.tm.plugin.rest.service.RestExecutionService;
import org.squashtest.tm.plugin.rest.validators.CustomFieldValueHintedValidator;
import org.squashtest.tm.plugin.rest.validators.DenormalizedFieldValueHintedValidator;
import org.squashtest.tm.plugin.rest.validators.ExecutionHintedValidator;

@RestApiController(value=Execution.class)
@UseDefaultRestApiConfiguration
public class RestExecutionController
extends BaseRestController {
    public static final String EXECUTION_DYNAMIC_FILTER = "*,execution_steps[execution_status,action,expected_result], nature[code], type[code], automated_execution_extender[result_url, result_status]";
    public static final String PATCH_DYNAMIC_FILTER = "comment, execution_status, custom_fields, test_case_custom_fields";
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private RestExecutionService restExecutionService;
    @Inject
    private CustomFieldValueHintedValidator cufValidator;
    @Inject
    private DenormalizedFieldValueHintedValidator denoValidator;
    @Inject
    private ExecutionHintedValidator execValidator;

    public void initBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.execValidator});
        binder.addValidators(new Validator[]{this.cufValidator});
        binder.addValidators(new Validator[]{this.denoValidator});
    }

    @RequestMapping(value={"/executions/{id}"}, method={RequestMethod.GET})
    @EntityGetter(value={Execution.class, ScriptedExecution.class, KeywordExecution.class})
    @ResponseBody
    @DynamicFilterExpression(value="*,execution_steps[execution_status,action,expected_result], nature[code], type[code], automated_execution_extender[result_url, result_status]")
    public ResponseEntity<Resource<Execution>> findExecution(@PathVariable(value="id") long id) {
        Execution execution = this.restExecutionService.getOne(id);
        Resource res = this.toResource((Identified)execution);
        this.linksHelper.addAllLinksForExecution((Resource<Execution>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/executions/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*,execution_steps[execution_status,action,expected_result], nature[code], type[code], automated_execution_extender[result_url, result_status]")
    @DeserializationFilterExpression(value="comment, execution_status, custom_fields, test_case_custom_fields")
    public ResponseEntity<Resource<Execution>> patchExecution(@Validated @PersistentEntity ExecutionAndCustomFields exec) {
        this.restExecutionService.updateExecution(exec);
        Resource res = this.toResource((Identified)((Execution)exec.getWrapped()));
        this.linksHelper.addAllLinksForExecution((Resource<Execution>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/executions/{id}/execution-steps"})
    @ResponseBody
    @DynamicFilterExpression(value="*, execution[execution_status]")
    public ResponseEntity<PagedResources<Resource>> findExecutionSteps(@PathVariable(value="id") long executionId, Pageable pageable) {
        Page<ExecutionStep> steps = this.restExecutionService.findExecutionSteps(executionId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(steps, "execution-steps");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/executions/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> deleteExecution(@PathVariable(value="id") Long executionId) {
        this.restExecutionService.deleteExecution(executionId);
        return ResponseEntity.noContent().build();
    }
}

