/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.List;
import javax.inject.Inject;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetDto;
import org.squashtest.tm.plugin.rest.service.RestDatasetService;
import org.squashtest.tm.plugin.rest.validators.DatasetValidator;

@RestApiController(value=Dataset.class)
@UseDefaultRestApiConfiguration
public class RestDatasetController
extends BaseRestController {
    @Inject
    private RestDatasetService restDatasetService;
    @Inject
    private DatasetValidator datasetValidator;
    @Inject
    private ResourceLinksHelper linksHelper;

    @RequestMapping(value={"/datasets/{id}"})
    @EntityGetter
    @DynamicFilterExpression(value="*,parameters[name],test_case[name]")
    public ResponseEntity<Resource<Dataset>> findParameter(@PathVariable(value="id") long id) {
        Dataset dataset = this.restDatasetService.getOne(id);
        Resource res = new Resource((Object)dataset, new Link[0]);
        res.add(this.createSelfLink((Identified)dataset));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/datasets"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<Dataset>> addDataset(@RequestBody DatasetDto datasetDto) throws BindException {
        List<Parameter> listAllParamByIdTc = this.restDatasetService.findAllParametersByTc(datasetDto.getReferencedTestCase().getId());
        this.datasetValidator.validationPostDataset(datasetDto, listAllParamByIdTc);
        Dataset dataset = this.restDatasetService.addDataset(datasetDto, listAllParamByIdTc);
        Resource res = this.toResource((Identified)dataset);
        this.linksHelper.addAllLinksForDataset((Resource<Dataset>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/datasets/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<Dataset>> ModifyDataset(@RequestBody DatasetDto datasetDto, @PathVariable(value="id") long datasetId) throws BindException {
        this.datasetValidator.validationPatchDataset(datasetDto, datasetId);
        Dataset dataset = this.restDatasetService.modifyDataset(datasetDto, datasetId);
        Resource res = this.toResource((Identified)dataset);
        this.linksHelper.addAllLinksForDataset((Resource<Dataset>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/datasets/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> removeDataset(@PathVariable(value="id") Long datasetId) {
        this.restDatasetService.deleteDataset(datasetId);
        return ResponseEntity.noContent().build();
    }
}

