/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.ContentInclusion;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignFolderDto;
import org.squashtest.tm.plugin.rest.service.RestCampaignFolderService;
import org.squashtest.tm.plugin.rest.validators.CampaignFolderPatchValidator;
import org.squashtest.tm.plugin.rest.validators.CampaignFolderPostValidator;

@RestApiController(value=CampaignFolder.class)
@UseDefaultRestApiConfiguration
public class RestCampaignFolderController
extends BaseRestController {
    @Inject
    private RestCampaignFolderService service;
    @Inject
    private CampaignFolderPostValidator campaignFolderPostValidator;
    @Inject
    private CampaignFolderPatchValidator campaignFolderPatchValidator;
    @Inject
    private ResourceLinksHelper linksHelper;

    @RequestMapping(value={"/campaign-folders"})
    @ResponseBody
    @DynamicFilterExpression(value="name")
    public ResponseEntity<PagedResources<Resource>> findAllReadableTestCaseFolders(Pageable pageable) {
        Page<CampaignFolder> folders = this.service.findAllReadable(pageable);
        PagedResources res = this.toPagedResources(folders);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/campaign-folders/{id}"}, method={RequestMethod.GET})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<Resource<CampaignFolder>> findCampaignFolder(@PathVariable(value="id") long id) {
        CampaignFolder campaignFolder = this.service.getOne(id);
        Resource res = this.toResource((Identified)campaignFolder);
        res.add(this.createLinkTo((Identified)campaignFolder.getProject()));
        res.add(this.createRelationTo("content"));
        res.add(this.createRelationTo("attachments"));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/campaign-folders/{id}/content"})
    @ResponseBody
    @DynamicFilterExpression(value="name,reference")
    public ResponseEntity<PagedResources<Resource>> findCampaignFolderContent(@PathVariable(value="id") long folderId, Pageable pageable, ContentInclusion include) {
        Page<CampaignLibraryNode> content;
        switch (include) {
            case NESTED: {
                content = this.service.findFolderAllContent(folderId, pageable);
                break;
            }
            default: {
                content = this.service.findFolderContent(folderId, pageable);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(content, "content");
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/campaign-folders"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<Resource<CampaignFolder>> createCampaignFolder(@RequestBody CampaignFolderDto folderDto) throws BindException, InvocationTargetException, IllegalAccessException {
        this.campaignFolderPostValidator.validatePostCampaignFolder(folderDto);
        CampaignFolder folder = this.service.addCampaignFolder(folderDto);
        Resource res = this.toResource((Identified)folder);
        this.linksHelper.addAllLinksForCampaignFolder((Resource<CampaignFolder>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/campaign-folders/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<Resource<CampaignFolder>> patchCampaignFolder(@RequestBody CampaignFolderDto folderPatch, @PathVariable(value="id") long id) throws BindException {
        folderPatch.setId(id);
        this.campaignFolderPatchValidator.validatePatchCampaignFolder(folderPatch);
        CampaignFolder folder = this.service.patchCampaignFolder(folderPatch, id);
        Resource res = this.toResource((Identified)folder);
        this.linksHelper.addAllLinksForCampaignFolder((Resource<CampaignFolder>)res);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/campaign-folders/{ids}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Void> deleteCampaignFolder(@PathVariable(value="ids") List<Long> folderIds) {
        this.service.deleteFolder(folderIds);
        return ResponseEntity.noContent().build();
    }
}

