/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignDto;
import org.squashtest.tm.plugin.rest.service.RestCampaignService;
import org.squashtest.tm.plugin.rest.validators.CampaignPatchValidator;
import org.squashtest.tm.plugin.rest.validators.CampaignPostValidator;

@RestApiController(value=Campaign.class)
@UseDefaultRestApiConfiguration
public class RestCampaignController
extends BaseRestController {
    public static final String ITERATION_EMBEDDED_FILTER = "*, parent[name], -test_plan, test_suites[name],-path,-campaign";
    public static final String CTPI_EMBEDDED_FILTER = "*,referenced_test_case[name, reference], referenced_dataset[name], campaign[name,reference],-campaign";
    @Inject
    private RestCampaignService restCampaignService;
    @Inject
    private CampaignPostValidator campaignPostValidator;
    @Inject
    private CampaignPatchValidator campaignPatchValidator;

    @GetMapping(value={"/campaigns/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name], iterations[name], test_plan[referenced_test_case[name]]")
    public ResponseEntity<Resource<Campaign>> findCampaign(@PathVariable(value="id") long id) {
        Campaign campaign = this.restCampaignService.getOne(id);
        Resource res = this.toResource((Identified)campaign);
        res.add(this.linkService.createLinkTo((Identified)campaign.getProject()));
        res.add(this.createRelationTo("iterations"));
        res.add(this.createRelationTo("test-plan"));
        res.add(this.createRelationTo("attachments"));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/campaignsByName/{name}"})
    @ResponseBody
    @DynamicFilterExpression(value="name,reference")
    public ResponseEntity<PagedResources<Resource>> findCampaignByName(@PathVariable(value="name") String campaignName, Pageable pageable) {
        Page<Campaign> campaigns = this.restCampaignService.findAllByName(campaignName, pageable);
        PagedResources res = this.toPagedResources(campaigns);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/campaigns"})
    @ResponseBody
    @DynamicFilterExpression(value="name,reference")
    public ResponseEntity<PagedResources<Resource>> findAllReadableCampaigns(Pageable pageable) {
        Page<Campaign> tcs = this.restCampaignService.findAllReadable(pageable);
        PagedResources res = this.toPagedResources(tcs);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/campaigns"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<Campaign>> createCampaign(@RequestBody CampaignDto campaignDto) throws BindException {
        this.validatePostCampaign(campaignDto);
        Campaign campaign = this.restCampaignService.createCampaign(campaignDto);
        Resource res = this.toResource((Identified)campaign);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/campaigns/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<Campaign>> patchCampaign(@RequestBody CampaignDto campaignDto, @PathVariable(value="id") long id) throws BindException {
        campaignDto.setId(id);
        this.validatePatchCampaign(campaignDto);
        Campaign campaign = this.restCampaignService.patchCampaign(campaignDto, id);
        Resource res = this.toResource((Identified)campaign);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/campaigns/{ids}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> deleteCampaign(@PathVariable(value="ids") List<Long> ids) throws BindException {
        this.restCampaignService.deleteCampaignsByIds(ids);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/campaigns/{id}/iterations"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -test_plan, test_suites[name],-path,-campaign")
    public ResponseEntity<PagedResources<Resource>> findAllCampaignIterations(@PathVariable(value="id") long id, Pageable pageable) {
        Page<Iteration> tcs = this.restCampaignService.findIterations(id, pageable);
        PagedResources res = this.toPagedResources(tcs);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/campaigns/{id}/test-plan"})
    @ResponseBody
    @DynamicFilterExpression(value="*,referenced_test_case[name, reference], referenced_dataset[name], campaign[name,reference],-campaign")
    public ResponseEntity<PagedResources<Resource>> findAllCampaignTestPlan(@PathVariable(value="id") long id, Pageable pageable) {
        Page<CampaignTestPlanItem> tcs = this.restCampaignService.findTestPlan(id, pageable);
        PagedResources res = this.toPagedResources(tcs);
        return ResponseEntity.ok((Object)res);
    }

    private void validatePostCampaign(CampaignDto dto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)dto, "post-campaign");
        this.campaignPostValidator.validate(dto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(dto, errors, "post-campaign");
    }

    private void validatePatchCampaign(CampaignDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, "patch-campaign");
        this.campaignPatchValidator.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, "patch-campaign");
    }
}

