/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkBuilder;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.AutomatedSuiteDto;
import org.squashtest.tm.plugin.rest.service.RestAutomatedExecutionExtenderService;
import org.squashtest.tm.plugin.rest.service.RestAutomatedSuiteService;

@RestApiController
@UseDefaultRestApiConfiguration
public class RestAutomatedSuiteController
extends BaseRestController {
    @Inject
    private RestAutomatedSuiteService automatedSuiteService;
    @Inject
    private RestAutomatedExecutionExtenderService automatedExecutionExtenderService;
    private AutomatedSuiteResourceAssembler suiteResourceAssembler = new AutomatedSuiteResourceAssembler();

    @RequestMapping(value={"/automated-suites"}, method={RequestMethod.GET})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<PagedResources<Resource>> findAllReadableAutomatedSuites(Pageable pageable) {
        Page<AutomatedSuite> suites = this.automatedSuiteService.findAllReadable(pageable);
        Page suiteDtos = suites.map(suite -> new AutomatedSuiteDto(suite.getId(), suite.getExecutionExtenders()));
        PagedResources res = this.pageAssembler.toResource(suiteDtos, (ResourceAssembler)this.suiteResourceAssembler);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/automated-suites/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<AutomatedSuiteDto>> findAutomatedSuite(@PathVariable(value="id") String id) {
        AutomatedSuite suite = this.automatedSuiteService.findById(id);
        Resource<AutomatedSuiteDto> res = this.toResource(suite);
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        res.add(new Link(builder.toUriString(), "self"));
        builder.path("/executions");
        res.add(new Link(builder.toUriString(), "executions"));
        return ResponseEntity.ok(res);
    }

    @RequestMapping(value={"/automated-suites/{id}/executions"}, method={RequestMethod.GET})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<PagedResources<Resource>> findAutomatedSuiteExecutions(@PathVariable(value="id") String id, Pageable pageable) {
        Page<AutomatedExecutionExtender> executions = this.automatedExecutionExtenderService.findAutomatedExecutionExtenderByAutomatedSuiteId(id, pageable);
        PagedResources res = this.toPagedResources(executions);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/automated-suite-utils/from-iteration-test-plan-items"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<AutomatedSuiteDto>> createAutomatedSuiteFromIterationTestPlanItems(@RequestParam(value="itemIds") List<Long> itemIds) {
        AutomatedSuite suite = this.automatedSuiteService.createAutomatedSuiteFromIterationTestPlanItems(itemIds);
        Resource<AutomatedSuiteDto> res = this.toResource(suite);
        this.addAllLinksForAutomatedSuite(suite.getId(), res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(res);
    }

    @RequestMapping(value={"/automated-suite-utils/from-test-suite"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<AutomatedSuiteDto>> createAutomatedSuiteFromTestSuite(@RequestParam(value="testSuiteId") long testSuiteId) {
        AutomatedSuite suite = this.automatedSuiteService.createAutomatedSuiteFromTestSuite(testSuiteId);
        Resource<AutomatedSuiteDto> res = this.toResource(suite);
        this.addAllLinksForAutomatedSuite(suite.getId(), res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(res);
    }

    @RequestMapping(value={"/automated-suite-utils/from-iteration"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<AutomatedSuiteDto>> createAutomatedSuiteFromIteration(@RequestParam(value="iterationId") long iterationId) {
        AutomatedSuite suite = this.automatedSuiteService.createAutomatedSuiteFromIteration(iterationId);
        Resource<AutomatedSuiteDto> res = this.toResource(suite);
        this.addAllLinksForAutomatedSuite(suite.getId(), res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(res);
    }

    @RequestMapping(value={"/automated-suite-utils/{suiteId}/executor"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<AutomatedSuiteDto>> executeAutomatedSuite(@PathVariable(value="suiteId") String suiteId) {
        AutomatedSuite suite = this.automatedSuiteService.findById(suiteId);
        this.automatedSuiteService.start(suite);
        Resource<AutomatedSuiteDto> res = this.toResource(suite);
        this.addAllLinksForAutomatedSuite(suite.getId(), res);
        return ResponseEntity.ok(res);
    }

    private Resource<AutomatedSuiteDto> toResource(AutomatedSuite suite) {
        AutomatedSuiteDto suiteDto = new AutomatedSuiteDto(suite.getId(), suite.getExecutionExtenders());
        return new Resource((Object)suiteDto, new Link[0]);
    }

    private void addAllLinksForAutomatedSuite(String suiteId, Resource<AutomatedSuiteDto> res) {
        LinkBuilder builder = this.linkService.fromBasePath(ControllerLinkBuilder.linkTo(((RestAutomatedSuiteController)((Object)ControllerLinkBuilder.methodOn(RestAutomatedSuiteController.class, (Object[])new Object[0]))).findAutomatedSuite(suiteId)));
        res.add(new Link(builder.toString(), "self"));
        res.add(new Link(builder.slash((Object)"/executions").toString(), "executions"));
    }

    private class AutomatedSuiteResourceAssembler
    implements ResourceAssembler<AutomatedSuiteDto, Resource<AutomatedSuiteDto>> {
        private AutomatedSuiteResourceAssembler() {
        }

        public Resource<AutomatedSuiteDto> toResource(AutomatedSuiteDto entity) {
            Resource res = new Resource((Object)entity, new Link[0]);
            RestAutomatedSuiteController.this.addAllLinksForAutomatedSuite(entity.getId(), (Resource<AutomatedSuiteDto>)res);
            return res;
        }
    }
}

