/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.service.RestAttachmentService;

@RestApiController(value=Attachment.class)
@UseDefaultRestApiConfiguration
public class RestAttachmentController
extends BaseRestController {
    @Inject
    private RestAttachmentService restAttachmentService;

    @RequestMapping(value={"/attachments/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<Attachment>> findAttachment(@PathVariable(value="id") long id) throws IOException {
        Attachment attachment = this.restAttachmentService.findById(id);
        Resource res = new Resource((Object)attachment, new Link[0]);
        res.add(this.createSelfLink((Identified)attachment));
        res.add(this.linkService.fromBasePath(ControllerLinkBuilder.linkTo((Object)((RestAttachmentController)((Object)ControllerLinkBuilder.methodOn(RestAttachmentController.class, (Object[])new Object[0]))).downloadAttachment(id))).withRel("content"));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/attachments/{id}"}, method={RequestMethod.PATCH})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Resource<Attachment>> renameAttachment(@PathVariable(value="id") long id, @RequestParam(value="name") String name) throws IOException {
        Attachment attachment = this.restAttachmentService.renameAttachment(id, name);
        Resource res = new Resource((Object)attachment, new Link[0]);
        res.add(this.createSelfLink((Identified)attachment));
        res.add(this.linkService.fromBasePath(ControllerLinkBuilder.linkTo((Object)((RestAttachmentController)((Object)ControllerLinkBuilder.methodOn(RestAttachmentController.class, (Object[])new Object[0]))).downloadAttachment(id))).withRel("content"));
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/attachments/{id}/content"}, produces={"application/octet-stream"})
    @Transactional(readOnly=true)
    public ResponseEntity downloadAttachment(@PathVariable(value="id") long id) throws IOException {
        Attachment attachment = this.restAttachmentService.findById(id);
        InputStream in = attachment.getContent().getStream();
        byte[] out = IOUtils.toByteArray((InputStream)in);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Disposition", "attachment; filename=" + attachment.getName().replace(" ", "_"));
        responseHeaders.add("Content-Type", "application/octet-stream");
        return new ResponseEntity((Object)out, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/{owner}/{ownerId}/attachments"}, method={RequestMethod.GET})
    @ResponseBody
    @DynamicFilterExpression(value="*, -type,-size, -added_on")
    public ResponseEntity<PagedResources<Resource>> findAttachmentsByOwner(@PathVariable(value="owner") String owner, @PathVariable(value="ownerId") long ownerId, Pageable pageable) {
        AttachmentHolder holder = this.restAttachmentService.findHolder(owner, ownerId);
        Page<Attachment> attachments = this.restAttachmentService.findPagedAttachments(holder, pageable);
        PagedResources res = this.toPagedResources(attachments);
        return ResponseEntity.ok((Object)res);
    }

    @RequestMapping(value={"/{owner}/{ownerId}/attachments"}, method={RequestMethod.POST})
    @ResponseBody
    @DynamicFilterExpression(value="*, -type,-size, -added_on")
    public ResponseEntity<Resources> uploadAttachments(@PathVariable(value="owner") String owner, @PathVariable(value="ownerId") long ownerId, @RequestParam(value="files") List<MultipartFile> files) {
        AttachmentHolder holder = this.restAttachmentService.findHolderWithPermission(owner, ownerId, "CREATE");
        List<Attachment> attachments = this.restAttachmentService.addAttachments(holder, files);
        List resources = attachments.stream().map(attachment -> {
            Resource res = new Resource(attachment, new Link[0]);
            res.add(this.createSelfLink((Identified)attachment));
            return res;
        }).collect(Collectors.toList());
        Resources res = new Resources(resources, new Link[0]);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @RequestMapping(value={"/{owner}/{ownerId}/attachments"}, method={RequestMethod.DELETE})
    @ResponseBody
    @DynamicFilterExpression(value="*, -type,-size, -added_on")
    public ResponseEntity<Void> deleteAttachments(@PathVariable(value="owner") String owner, @PathVariable(value="ownerId") long ownerId, @RequestParam(value="attachmentIds") List<Long> attachmentIds) throws IOException {
        AttachmentHolder holder = this.restAttachmentService.findHolderWithPermission(owner, ownerId, "DELETE");
        this.restAttachmentService.deleteAttachments(holder, attachmentIds);
        return ResponseEntity.noContent().build();
    }
}

