select RLNP.ANCESTOR_ID, RLN.PROJECT_ID, VERSION.RES_ID, VERSION.REQUIREMENT_ID, VERSION.REFERENCE, VERSION.VERSION_NUMBER, 
VERSION.CRITICALITY, VERSION.REQUIREMENT_STATUS, VERSION.CATEGORY, COUNT(ATTACH.ATTACHMENT_ID), 
RES.NAME, RES.DESCRIPTION, RES.CREATED_BY, RES.CREATED_ON, RES.LAST_MODIFIED_BY, RES.LAST_MODIFIED_ON, 
LAST_VERSION.VERSION_NUMBER AS TOTAL_VERSION 
from REQUIREMENT_VERSION VERSION 
inner join REQUIREMENT REQ on REQ.RLN_ID = VERSION.REQUIREMENT_ID 
inner join REQUIREMENT_VERSION LAST_VERSION on REQ.CURRENT_VERSION_ID = LAST_VERSION.RES_ID 
inner join REQUIREMENT_LIBRARY_NODE RLN on RLN.RLN_ID = VERSION.REQUIREMENT_ID 
left join RLN_RELATIONSHIP RLNP on RLNP.DESCENDANT_ID = RLN.RLN_ID 
inner join RESOURCE RES on RES.RES_ID = VERSION.RES_ID 
left join ATTACHMENT ATTACH on ATTACH.ATTACHMENT_LIST_ID = RES.ATTACHMENT_LIST_ID 
where VERSION.REQUIREMENT_ID in (:requirementIds) 
group by VERSION.REQUIREMENT_ID, VERSION.RES_ID  
order by VERSION.VERSION_NUMBER asc 
