-- comments
-- 
-- 1/ chain_id is now a placeholder for a data that isn't used anymore,
-- 2/ same goes for node_type
-- 3/ we test that a given node is a folder or a test case by testing if it's tc_type is null (that cannot happen for regular test cases)

select 
	group_concat(tcln_clos.name order by clos.depth desc separator ' > ') as chain,
	tcln.tcln_id as id,
	'WHATEVER' as chain_id,
	(case when tc.tc_type is NULL then 1 else 0 end) as folder,
	tcln.name as name,
	max(clos.depth) as level,
	ifnull(tc.importance, 'UNDEFINED') as importance,
	ifnull(tc.tc_nature, 'UNDEFINED') as tcnature,
	ifnull(tc.tc_type, 'UNDEFINED') as tctype,
	ifnull(tc.tc_status, 'WORK_IN_PROGRESS') as tcstatus,
	ifnull(tc.ta_test, '-1') as execution_mode, 
	ifnull(tc.prerequisite, ' ') as prerequisites,
	ifnull(tc.reference, ' ') as reference,
	tcln.created_on as created_on,
	tcln.created_by as created_by,
	tcln.last_modified_on as last_modified_on,
	tcln.last_modified_by as last_modified_by,
	tcln.description as description,
	'D' as node_type,
	count(attach.attachment_id) as attachments,
	group_concat(concat((case when tc_clos.tc_type is NULL then '1' else '0' end), ifnull(tc_clos.reference, ' '), tcln_clos.name) order by clos.depth desc separator ' ') as sorting_key		   
from TCLN_RELATIONSHIP_CLOSURE clos
inner join TEST_CASE_LIBRARY_NODE tcln_clos on clos.ancestor_id=tcln_clos.tcln_id
left join TEST_CASE tc_clos on tcln_clos.tcln_id = tc_clos.tcln_id
inner join TEST_CASE_LIBRARY_NODE tcln on clos.descendant_id=tcln.tcln_id
left join TEST_CASE tc on tcln.tcln_id = tc.tcln_id
left join ATTACHMENT attach on attach.attachment_list_id = tcln.attachment_list_id 
where clos.descendant_id in (select clos1.ancestor_id from TCLN_RELATIONSHIP_CLOSURE clos1 where clos1.descendant_id = :nodeId)
or clos.descendant_id in (select clos2.descendant_id from TCLN_RELATIONSHIP_CLOSURE clos2 where clos2.ancestor_id = :nodeId)
group by clos.descendant_id
order by sorting_key