SELECT NULL AS CHAIN,
tcrc.ANCESTOR_ID AS ID,
CONCAT('/',tcrc.ANCESTOR_ID, '/') AS CHAIN_ID,
1 AS FOLDER,
tcln.NAME AS NAME,
tcrc.DEPTH * -1 + (
SELECT MAX(DEPTH)
FROM
TCLN_RELATIONSHIP_CLOSURE tcrc2
WHERE tcrc2.DESCENDANT_ID = :nodeId) AS LEVEL,
'UNDEFINED' AS IMPORTANCE,
'UNDEFINED' AS TCNATURE,
'UNDEFINED' AS TCTYPE,
'WORK_IN_PROGRESS' AS TCSTATUS,
'-1' AS EXECUTION_MODE,
' ' AS PREREQUISITES,
' ' AS REFERENCE,
tcln.CREATED_ON AS CREATED_ON,
tcln.CREATED_BY AS CREATED_BY,
tcln.LAST_MODIFIED_ON AS LAST_MODIFIED_ON,
tcln.LAST_MODIFIED_BY AS LAST_MODIFIED_BY,
tcln.DESCRIPTION AS DESCRIPTION,
'A' AS NODE_TYPE,
'0' AS ATTACHMENTS, 
NULL as SORTING_CHAIN
FROM TCLN_RELATIONSHIP_CLOSURE tcrc
JOIN TEST_CASE_LIBRARY_NODE tcln ON tcln.TCLN_ID = tcrc.ANCESTOR_ID
WHERE tcrc.DESCENDANT_ID = :nodeId AND tcrc.DEPTH <> 0 

UNION ALL

SELECT *
FROM(
	SELECT 
	GROUP_CONCAT(rcln2.NAME ORDER BY tcrc.DEPTH DESC SEPARATOR ' > ') AS CHAIN,
	tcrc.DESCENDANT_ID AS ID,
	CONCAT('/', GROUP_CONCAT(tcrc.ANCESTOR_ID ORDER BY tcrc.DEPTH DESC SEPARATOR '/'), '/') AS CHAIN_ID,
	IFNULL((SELECT 1 FROM TEST_CASE_FOLDER tcf WHERE tcrc.DESCENDANT_ID = tcf.TCLN_ID),0) AS FOLDER,
	tcln.NAME AS NAME, MAX(tcrc.DEPTH) AS LEVEL, 
	IFNULL(tc.IMPORTANCE, 'UNDEFINED') AS IMPORTANCE, 
	IFNULL(tc.TC_NATURE, 'UNDEFINED') AS TCNATURE,
	IFNULL(tc.TC_TYPE, 'UNDEFINED') AS TCTYPE,
	IFNULL(tc.TC_STATUS, 'WORK_IN_PROGRESS') AS TCSTATUS,
	IFNULL(tc.TA_TEST, '-1') AS EXECUTION_MODE, 
	IFNULL(tc.PREREQUISITE, ' ') AS PREREQUISITES,
	IFNULL(tc.REFERENCE, ' ') AS REFERENCE,
	tcln.CREATED_ON AS CREATED_ON,
	tcln.CREATED_BY AS CREATED_BY,
	tcln.LAST_MODIFIED_ON AS LAST_MODIFIED_ON,
	tcln.LAST_MODIFIED_BY AS LAST_MODIFIED_BY,
	tcln.DESCRIPTION AS DESCRIPTION,
	'D' AS NODE_TYPE,
	IFNULL(subtable.ATTACH, 0) AS ATTACHMENTS,
	GROUP_CONCAT(sortkeyview.SORTING_NAME ORDER BY tcrc.DEPTH DESC SEPARATOR ' > ') as SORTING_CHAIN
FROM TCLN_RELATIONSHIP_CLOSURE tcrc
JOIN TEST_CASE_LIBRARY_NODE tcln ON tcln.TCLN_ID = tcrc.DESCENDANT_ID
LEFT OUTER JOIN TEST_CASE tc ON tc.TCLN_ID = tcln.TCLN_ID
JOIN TEST_CASE_LIBRARY_NODE rcln2 ON rcln2.TCLN_ID = tcrc.ANCESTOR_ID
JOIN (
	-- the sorting key for each node is <isfolder><reference><name> ensuring that folders 
	-- are ranked after the test cases
	select tclnrew.TCLN_ID, CONCAT(CASE WHEN tcrew.TCLN_ID IS NULL THEN '1' ELSE '0' END , IFNULL(tcrew.REFERENCE, ' '), tclnrew.NAME ) as SORTING_NAME
	from TEST_CASE_LIBRARY_NODE tclnrew left outer join  TEST_CASE tcrew on tclnrew.TCLN_ID = tcrew.TCLN_ID  
) sortkeyview ON sortkeyview.TCLN_ID = tcrc.ANCESTOR_ID
LEFT OUTER JOIN (SELECT Count(*) AS ATTACH,tcln.TCLN_ID AS HEY
		 FROM ATTACHMENT att
		 JOIN TEST_CASE_LIBRARY_NODE tcln ON att.ATTACHMENT_LIST_ID = tcln.ATTACHMENT_LIST_ID
		 JOIN TCLN_RELATIONSHIP tclnr ON tclnr.DESCENDANT_ID = tcln.TCLN_ID
		 GROUP BY tcln.TCLN_ID) AS subtable
		 ON subtable.HEY = tc.TCLN_ID
GROUP BY tcrc.DESCENDANT_ID)req
WHERE req.CHAIN_ID LIKE CONCAT('%/', :nodeId,'/%')
ORDER BY SORTING_CHAIN ASC


	
