SELECT rv.REQUIREMENT_ID AS ID,
r.NAME AS NAME,
p.NAME AS PROJECT_NAME,
rv.CRITICALITY AS CRITICALITY,
rv.VERSION_NUMBER AS VERSION
FROM RESOURCE r
JOIN REQUIREMENT_VERSION rv ON rv.RES_ID = r.RES_ID
JOIN TEST_CASE_VERIFIED_REQUIREMENT_VERSION tcvrv ON tcvrv.VERIFIED_REQ_VERSION_ID = rv.RES_ID
JOIN REQUIREMENT_LIBRARY_NODE rln ON rln.RLN_ID = rv.REQUIREMENT_ID
JOIN PROJECT p ON p.PROJECT_ID = rln.PROJECT_ID
WHERE tcvrv.VERIFYING_TEST_CASE_ID = :tcId 
UNION
SELECT rv.REQUIREMENT_ID AS ID,
r.NAME AS NAME,
p.NAME AS PROJECT_NAME,
rv.CRITICALITY AS CRITICALITY,
rv.VERSION_NUMBER AS VERSION
FROM RESOURCE r
JOIN REQUIREMENT_VERSION rv ON rv.RES_ID = r.RES_ID
JOIN TEST_CASE_VERIFIED_REQUIREMENT_VERSION tcvrv ON tcvrv.VERIFIED_REQ_VERSION_ID = rv.RES_ID
JOIN REQUIREMENT_LIBRARY_NODE rln ON rln.RLN_ID = rv.REQUIREMENT_ID
JOIN PROJECT p ON p.PROJECT_ID = rln.PROJECT_ID
JOIN CALL_TEST_STEP cts ON cts.CALLED_TEST_CASE_ID = tcvrv.VERIFYING_TEST_CASE_ID
JOIN TEST_CASE_STEPS tcs ON tcs.STEP_ID = cts.TEST_STEP_ID
WHERE tcs.TEST_CASE_ID = :tcId